/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.io.Writer;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.CertTool;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.TestRecord;

@Scanned
public class IdpOverviewServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;

    @Inject
    public IdpOverviewServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.userLookupService = bucket.getUserLookupService();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        resp.setContentType("text/html");
        String id = this.getId(req);
        IdpConfiguration idpConfig = this.idpConfManager.getIdentityProviderById(id);
        if (idpConfig == null) {
            resp.sendError(404);
            return;
        }
        model.put("topMenu", "SAML");
        model.put("menuItem", "overview");
        model.put("idp", idpConfig);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("defaultGroups", this.idpConfManager.commaSeparated(idpConfig.getDefaultGroups()));
        model.put("knownDomains", idpConfig.getKnownDomains());
        model.put("matchingConnectors", this.connectorConfManager.findMatchingConnectors(idpConfig.getKind()));
        model.put("connectorTypes", this.connectorConfManager.getConnectorTypes());
        model.put("dateTool", new DateTool());
        model.put("userTestURL", this.idpConfManager.getServiceProviderNonAdminTestURL(req, id));
        model.put("selectedUserLookupTransform", idpConfig.getUserLookupTransform().toString());
        model.put("isSingleLogoutEnabled", idpConfig.isSingleLogoutEnabled());
        idpConfig.ifSaml(samlConf -> {
            List<byte[]> signingCerts = samlConf.getSigningCerts();
            CertTool certTool = new CertTool();
            List validationCerts = io.vavr.collection.List.ofAll(signingCerts).map(bytes -> {
                X509Certificate cert = certTool.parse((byte[])bytes);
                JSONObject certJson = new JSONObject();
                certJson.put("subjectDn", cert.getSubjectDN().getName());
                certJson.put("notBefore", cert.getNotBefore().toString());
                certJson.put("notAfter", cert.getNotAfter().toString());
                certJson.put("sigAlgName", cert.getSigAlgName());
                certJson.put("keySize", String.valueOf(certTool.getKeySize(cert)));
                certJson.put("fingerPrint", certTool.fingerPrint((byte[])bytes));
                return certJson;
            }).asJava();
            model.put("validationCerts", validationCerts);
        });
        List<TestRecord> recordedTests = this.idpConfManager.getRecordedTests(idpConfig.getId());
        if (!recordedTests.isEmpty()) {
            model.put("latestTest", recordedTests.iterator().next());
        }
        ArrayList<Directory> matchingUserDirectories = new ArrayList<Directory>();
        for (Directory directory : this.userLookupService.getActiveUserDirectories()) {
            if (!idpConfig.getMatchedUserDirectoryIds().contains(directory.getId())) continue;
            matchingUserDirectories.add(directory);
        }
        model.put("matchingUserDirectories", matchingUserDirectories);
        this.getTemplateRenderer().render("templates/saml/idp-overview.vm", model, (Writer)resp.getWriter());
    }

    private String getId(HttpServletRequest req) {
        String p = req.getPathInfo();
        p = p.substring(0, p.lastIndexOf("/"));
        return p.substring(p.lastIndexOf("/") + 1);
    }
}

