/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.FingerprintSSLSocketFactory;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.MetadataParser;
import org.kantega.atlaskerb.saml.SAMLIdpConfiguration;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;

@Scanned
public class IdpMetadataServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final MetadataParser metadataParser = new MetadataParser();

    @Inject
    public IdpMetadataServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    public static String cleanString(String origString) {
        StringBuilder sb = new StringBuilder();
        for (char c : origString.toCharArray()) {
            if (!Character.isDigit(c) && !Character.isLetter(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        String id = this.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        if (configuration == null) {
            resp.sendError(404);
            return;
        }
        boolean autoRefreshMetadataEnabled = Try.of(() -> configuration).mapTry(SAMLIdpConfiguration.class::cast).mapTry(SAMLIdpConfiguration::isAutoRefreshMetadataEnabled).getOrElse(false);
        model.put("topMenu", "SAML");
        model.put("menuItem", "metadata");
        model.put("idp", configuration);
        model.put("metadataURL", this.idpConfManager.getServiceProviderMetadataURL(req, id));
        model.put("isAutoRefreshEnabled", autoRefreshMetadataEnabled);
        model.put("displayName", this.applicationProperties.getDisplayName());
        this.getTemplateRenderer().render("templates/saml/saml-idp-metadata.vm", model, (Writer)resp.getWriter());
    }

    private String getId(HttpServletRequest req) {
        String p = req.getPathInfo();
        p = p.substring(0, p.lastIndexOf("/"));
        return p.substring(p.lastIndexOf("/") + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        IdpConfigurationBuilder.SAML builder;
        Map<String, Object> model;
        InputStream metadataStream;
        MultipartHttpRequest req;
        block20: {
            req = this.getMultipartRequest(request, 1000000L);
            String id = this.getId((HttpServletRequest)req);
            String action = req.getParameter("action");
            String newFingerprint = req.getParameter("metadataTlsFingerprint");
            String metadataURL = req.getParameter("metadataURL");
            boolean refreshAuto = req.getParameter("refreshAuto") != null;
            boolean refreshNow = Option.of(req.getParameter("saveMetadataUrl")).map(parameter -> parameter.equals("Save and refresh metadata")).getOrElse(false);
            metadataStream = null;
            model = this.newModel((HttpServletRequest)req);
            model.put("action", action);
            SAMLIdpConfiguration samlConfig = this.idpConfManager.getIdentityProviderById(id).fold(saml -> {
                throw new RuntimeException("Did not expect OIDC config: " + id);
            }, Function.identity());
            builder = IdpConfigurationBuilder.of(samlConfig);
            if ("updateMetadata".equals(action)) {
                builder.setAutoRefreshMetadataEnabled(refreshAuto);
                builder.setMetadataURL(metadataURL);
                if (refreshNow && (metadataStream = this.refreshFromMetadata(id, model, metadataURL, newFingerprint, builder)) == null) {
                    this.renderPage((HttpServletRequest)req, resp, model);
                    return;
                }
            }
            if ("uploadMetadata".equals(action)) {
                byte[] file = req.getFile("file");
                if (file != null && file.length > 0) {
                    metadataStream = new ByteArrayInputStream(file);
                    break block20;
                } else {
                    model.put("missingFile", true);
                    this.renderPage((HttpServletRequest)req, resp, model);
                    return;
                }
            }
            if ("pasteMetadata".equals(action)) {
                String xml = req.getParameter("paste");
                if (xml != null && !xml.isEmpty()) {
                    metadataStream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
                } else {
                    model.put("missingPaste", true);
                    this.renderPage((HttpServletRequest)req, resp, model);
                    return;
                }
            }
        }
        if (metadataStream != null) {
            EntityDescriptor metadata = null;
            try {
                metadata = this.metadataParser.parse(metadataStream);
            }
            catch (Exception e) {
                model.put("parseException", e);
                this.renderPage((HttpServletRequest)req, resp, model);
                return;
            }
            finally {
                try {
                    metadataStream.close();
                }
                catch (Exception exception) {}
            }
            IDPSSODescriptor idpDesc = this.metadataParser.getIDPDescriptorForSaml(metadata);
            List<byte[]> signingCerts = this.metadataParser.getSigningCerts(idpDesc);
            MetadataParser.IdpSsoLocation idpLocation = this.metadataParser.getIdpSsoLocation(idpDesc);
            String idpSingleLogoutServiceURL = this.metadataParser.getIdpSingleLogoutServiceURL(idpDesc);
            builder.setIdpUrl(idpLocation.getLocation());
            builder.setUsePostBinding(idpLocation.usePostBinding());
            builder.setIdpSingleLogoutServiceURL(idpSingleLogoutServiceURL);
            builder.setSigningCerts(signingCerts);
            model.put("successUpdatedMetadata", true);
        }
        this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        this.renderPage((HttpServletRequest)req, resp, model);
    }

    private InputStream refreshFromMetadata(String id, Map<String, Object> model, String metadataURL, String newFingerprint, IdpConfigurationBuilder.SAML builder) {
        if (this.idpConfManager.getIdentityProviderById(id) instanceof SAMLIdpConfiguration) {
            String fingerprint;
            SAMLIdpConfiguration idp = (SAMLIdpConfiguration)this.idpConfManager.getIdentityProviderById(id);
            if (StringUtils.isNotBlank(newFingerprint)) {
                fingerprint = IdpMetadataServlet.cleanString(newFingerprint.toUpperCase());
                builder.setTlsFingerprint(fingerprint);
            } else {
                fingerprint = idp.getTlsFingerprint();
            }
            model.put("idpMetadataURL", metadataURL);
            if (metadataURL != null && !metadataURL.isEmpty()) {
                metadataURL = metadataURL.trim();
                try {
                    URL url = new URI(metadataURL).toURL();
                    try {
                        HttpURLConnection con = (HttpURLConnection)url.openConnection();
                        if (con instanceof HttpsURLConnection) {
                            HttpsURLConnection cons = (HttpsURLConnection)con;
                            cons.setSSLSocketFactory(new FingerprintSSLSocketFactory(fingerprint));
                        }
                        return con.getInputStream();
                    }
                    catch (SSLHandshakeException e) {
                        model.put("metadataSSLHandshakeException", e.getClass().getSimpleName() + ": " + e.getMessage());
                        model.put("untrustedServer", url.getProtocol() + "://" + url.getHost());
                        if (e.getCause() instanceof FingerprintSSLSocketFactory.FingerPrintException) {
                            X509Certificate[] certs = ((FingerprintSSLSocketFactory.FingerPrintException)e.getCause()).getX509Certificates();
                            List validationCerts = io.vavr.collection.List.ofAll(Arrays.asList(certs)).map(cert -> {
                                JSONObject certJson = new JSONObject();
                                certJson.put("subjectDn", cert.getSubjectDN().getName());
                                return certJson;
                            }).asJava();
                            model.put("untrustedCerts", validationCerts);
                        }
                        if (StringUtils.isNotBlank(newFingerprint)) {
                            model.put("wrongFingerPrint", newFingerprint);
                        }
                    }
                }
                catch (IOException e) {
                    model.put("metadataIOException", e.getClass().getSimpleName() + ": " + e.getMessage());
                }
                catch (Exception e) {
                    model.put("exceptionBadInput", "Something went wrong validating URI format: " + e);
                }
            } else {
                builder.setMetadataURL(null);
                this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
            }
        }
        return null;
    }

    @Override
    protected boolean expectsMultipart() {
        return true;
    }
}

