/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import io.vavr.Value;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class IdpJITServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ConnectorConfManager connectorConfManager;

    public IdpJITServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.connectorConfManager = bucket.getConnectorConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.buildModelAndRenderTemplate(req, resp);
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        resp.setContentType("text/html");
        Value maybeIdpConfiguration = this.idpConfManager.findIdentityProviderByIdFromPath(req).peek(idpConfiguration -> {
            boolean authenticatedAnonymousBrowsingAndCreateEnabledSimultaneously = idpConfiguration.isAuthenticatedAnonymousBrowsingEnabled() && idpConfiguration.getUserNotFoundPolicy().equals((Object)IdpConfiguration.UserNotFoundPolicy.CREATE);
            model.put("warningAuthenticatedAnonymousBrowsingEnabled", authenticatedAnonymousBrowsingAndCreateEnabledSimultaneously);
            model.put("idp", idpConfiguration);
            model.put("jitDirectory", idpConfiguration.getJitDirectory().orElse(-1L));
            model.put("displayName", this.applicationProperties.getDisplayName());
            model.put("canAddUser", this.hostApp.canAddUser());
            model.put("writableUserDirectories", this.hostApp.getWritableUserDirectories());
            model.put("topMenu", "SAML");
            model.put("menuItem", "jit");
            model.put("matchingConnectors", this.connectorConfManager.findMatchingConnectors(idpConfiguration.getKind()));
        });
        if (maybeIdpConfiguration.isDefined()) {
            this.getTemplateRenderer().render("templates/saml/idp-JIT.vm", model, (Writer)resp.getWriter());
        } else {
            resp.sendError(404);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String testId;
        String id = this.idpConfManager.getIdPIdFromPath(req);
        String action = req.getParameter("action");
        if ("editUserLookupSettings".equals(action)) {
            IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy = StringUtils.isNotEmpty(req.getParameter("createJITUsers")) ? IdpConfiguration.UserNotFoundPolicy.CREATE : IdpConfiguration.UserNotFoundPolicy.REJECT;
            IdpConfiguration.UserUpdatePolicy userUpdatePolicy = StringUtils.isNotEmpty(req.getParameter("updateJITUsers")) ? IdpConfiguration.UserUpdatePolicy.UPDATE : IdpConfiguration.UserUpdatePolicy.NONE;
            IdpConfiguration.UserActivatePolicy userActivatePolicy = StringUtils.isNotEmpty(req.getParameter("activateJITUsers")) ? IdpConfiguration.UserActivatePolicy.ACTIVATE : IdpConfiguration.UserActivatePolicy.NONE;
            String customNameAttribute = StringUtils.trimToNull(req.getParameter("customNameAttribute"));
            String customEmailAttribute = StringUtils.trimToNull(req.getParameter("customEmailAttribute"));
            IdpConfigurationBuilder<?, ?> builder = IdpConfigurationBuilder.ofGeneric(this.idpConfManager.getIdentityProviderById(id));
            builder.setUserNotFoundPolicy(userNotFoundPolicy);
            builder.setUserUpdatePolicy(userUpdatePolicy);
            builder.setUserUpdatePolicy(userUpdatePolicy);
            builder.setUserActivatePolicy(userActivatePolicy);
            builder.setCustomNameAttribute(customNameAttribute);
            builder.setCustomEmailAttribute(customEmailAttribute);
            Option.of(req.getParameter("JITDirectory")).map(Long::parseLong).peek(builder::setJitDirectory);
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        }
        if ((testId = req.getParameter("test")) != null) {
            resp.sendRedirect(this.idpConfManager.getServiceProviderEvaluateTestURL(req, id) + "?id=" + testId);
        } else {
            resp.sendRedirect("jit");
        }
    }
}

