/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.kantegasso.oidc.OidcProcedureData;
import io.vavr.collection.CharSeq;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Vector;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.identityproviders.OidcProcedureFactoryWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.ResumeOidcLoginServlet;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SamlXMLParser;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class IdpIntegrationServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;
    private final OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IdpConfiguration configuration;
    private String requestId;

    @Inject
    public IdpIntegrationServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.userLookupService = bucket.getUserLookupService();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.oidcProcedureFactoryWrapper = bucket.getOidcProcedureFactoryWrapper();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.requestId = this.getId(req);
        this.configuration = this.idpConfManager.getIdentityProviderById(this.requestId);
        this.renderPage(req, resp, this.newModel(req));
    }

    private void renderPage(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException, ServletException {
        resp.setContentType("text/html");
        if (this.configuration == null) {
            resp.sendError(404);
            return;
        }
        this.configuration = this.idpConfManager.getIdentityProviderById(this.getId(req));
        if (this.configuration.isOIDC()) {
            OIDCIdpConfiguration idpConfig = (OIDCIdpConfiguration)this.configuration;
            List<Object> scopesSupported = List.empty();
            String knownIssuer = null;
            Either maybeOidcData = this.oidcProcedureFactoryWrapper.createOidcProcedure(io.vavr.collection.HashMap.of("client_id", idpConfig.getClientId(), "client_secret", idpConfig.getClientSecret(), "discovery_url", idpConfig.getDiscoveryUrl(), "workaround", idpConfig.getKind().getOidcLibRepresentation(), "issuer_allowlist", idpConfig.getIssuerAllowList())).flatMap(data -> data.get("discovery_url").filter(StringUtils::isNotBlank).isDefined() ? data.discover() : Either.right(data));
            if (maybeOidcData.isLeft()) {
                this.log.warn(ErrorUtils.createErrorMessage("KSSO-GY912UU9Q2", maybeOidcData.getLeft()));
            } else {
                JSONObject discovery;
                OidcProcedureData oidcProcedureData = (OidcProcedureData)maybeOidcData.get();
                scopesSupported = oidcProcedureData.getScopesSupported();
                Option<JSONObject> maybeDiscovery = oidcProcedureData.get("discovery", JSONObject.class);
                if (!maybeDiscovery.isEmpty() && (discovery = maybeDiscovery.get()).has("issuer")) {
                    knownIssuer = discovery.getString("issuer");
                }
            }
            model.put("scopesSupported", scopesSupported);
            Set<String> savedScopes = ((OIDCIdpConfiguration)this.configuration).getScopes();
            model.put("savedScopes", String.join((CharSequence)",", savedScopes));
            model.put("knownIssuer", knownIssuer);
            String[] issuerAllowList = idpConfig.getIssuerAllowList();
            model.put("issuerAllowList", issuerAllowList);
            String issuerAllowListString = List.ofAll(Arrays.stream(issuerAllowList)).intersperse((Object)", ").foldLeft("", String::concat);
            model.put("issuerAllowListString", issuerAllowListString);
        }
        model.put("topMenu", "SAML");
        model.put("menuItem", "providerSettings");
        model.put("usernameAttributes", IdpConfiguration.UsernameAttribute.values());
        model.put("customUsernameAttributeName", this.configuration.getCustomUsernameAttributeName());
        model.put("idp", this.configuration);
        model.put("callbackUrl", ResumeOidcLoginServlet.getCallbackUrl(this.applicationProperties));
        model.put("canAddUser", this.hostApp.canAddUser());
        model.put("samlConfigURL", this.idpConfManager.getIdpConfigUrl(req));
        model.put("serviceURL", this.idpConfManager.getServiceProviderLoginURL(req, this.requestId));
        model.put("testingURL", this.idpConfManager.getServiceProviderTestURL(req, this.requestId));
        model.put("metadataURL", this.idpConfManager.getServiceProviderMetadataURL(req, this.requestId));
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("defaultGroups", this.idpConfManager.commaSeparated(this.configuration.getDefaultGroups()));
        model.put("serverName", req.getServerName());
        model.put("activeUserDirectories", this.userLookupService.getActiveUserDirectories());
        model.put("test", req.getParameter("test"));
        this.getTemplateRenderer().render("templates/saml/idp-integration.vm", model, (Writer)resp.getWriter());
    }

    private String getId(HttpServletRequest req) {
        String p = req.getPathInfo();
        p = p.substring(0, p.lastIndexOf("/"));
        return p.substring(p.lastIndexOf("/") + 1);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String testId;
        String id = this.getId(req);
        String addIssuer = req.getParameter("add-issuer");
        String deleteIssuer = req.getParameter("delete-issuer");
        String action = req.getParameter("action");
        if ("editIdp".equals(action)) {
            IdpConfiguration existing = this.idpConfManager.getIdentityProviderById(id);
            HashMap<String, Boolean> validationErrors = new HashMap<String, Boolean>();
            IdpConfigurationBuilder builder = existing.fold(oidc -> {
                IdpConfigurationBuilder.OIDC oidcBuilder = IdpConfigurationBuilder.of(oidc);
                String clientIdParam = StringUtils.trim(req.getParameter("clientId"));
                if (StringUtils.isNotEmpty(clientIdParam)) {
                    oidcBuilder.setOidcClientId(clientIdParam);
                } else {
                    validationErrors.put("clientIdRequired", true);
                }
                String clientSecretParam = StringUtils.trim(req.getParameter("clientSecret"));
                if (StringUtils.isNotEmpty(clientSecretParam)) {
                    oidcBuilder.setOidcClientSecret(clientSecretParam);
                } else {
                    validationErrors.put("clientSecretRequired", true);
                }
                String discoveryUrl = StringUtils.trim(req.getParameter("discoveryUrl"));
                if (StringUtils.isNotEmpty(discoveryUrl)) {
                    if (HttpUrlUtils.validateURL(discoveryUrl)) {
                        oidcBuilder.setOidcDiscoveryUrl(discoveryUrl);
                    } else {
                        validationErrors.put("discoveryUrlInvalid", true);
                    }
                }
                String oidcScopesString = StringUtils.trim(req.getParameter("oidcScopes"));
                LinkedHashSet<String> oidcScopes = SamlXMLParser.parseSet(oidcScopesString);
                oidcBuilder.setScopes(oidcScopes);
                LinearSeq oidcIssuerAllowList = ((Seq)Option.of(req.getParameter("issuerAllowListString")).map(StringUtils::deleteWhitespace).map(CharSeq::of).map(charSeq -> charSeq.split(",")).getOrElse(Vector.empty())).map(CharSeq::toString).toList();
                if (Objects.nonNull(deleteIssuer)) {
                    oidcIssuerAllowList = oidcIssuerAllowList.filter(issuer -> !Objects.equals(issuer, deleteIssuer));
                } else if (Objects.nonNull(addIssuer)) {
                    oidcIssuerAllowList = Option.of(req.getParameter("add-issuer-value")).map(StringUtils::deleteWhitespace).map(arg_0 -> oidcIssuerAllowList.push(arg_0)).getOrElse(oidcIssuerAllowList);
                }
                String[] oidcIssuerAllowArray = oidcIssuerAllowList.asJava().toArray(new String[0]);
                oidcBuilder.setIssuerAllowList(oidcIssuerAllowArray);
                return oidcBuilder;
            }, saml -> {
                IdpConfigurationBuilder.SAML samlBuilder = IdpConfigurationBuilder.of(saml);
                String location = StringUtils.trim(req.getParameter("location"));
                if (!StringUtils.isEmpty(location)) {
                    if (HttpUrlUtils.validateURL(location)) {
                        samlBuilder.setIdpUrl(location);
                    } else {
                        validationErrors.put("locationInvalid", true);
                    }
                } else {
                    validationErrors.put("locationRequired", true);
                }
                return samlBuilder;
            });
            String name = StringUtils.trim(req.getParameter("name"));
            if (StringUtils.isNotEmpty(name)) {
                builder.setName(name);
            } else {
                validationErrors.put("nameRequired", true);
            }
            String userLookupAttributeParam = StringUtils.trim(req.getParameter("userLookupAttribute"));
            if (!StringUtils.isEmpty(userLookupAttributeParam)) {
                builder.setUserLookupAttribute(IdpConfiguration.UserLookupAttribute.valueOf(userLookupAttributeParam));
            }
            if (!validationErrors.isEmpty()) {
                Map<String, Object> model = this.newModel(req);
                model.putAll(validationErrors);
                model.put("activeTab", "location");
                this.renderPage(req, resp, model);
                return;
            }
            this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
        }
        if ((testId = req.getParameter("test")) != null) {
            resp.sendRedirect(this.idpConfManager.getServiceProviderEvaluateTestURL(req, id) + "?id=" + testId);
        } else {
            resp.sendRedirect("idp-integration");
        }
    }
}

