/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Fingerprint {
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String formatSsha1Fingerprint(byte[] key) {
        String fingerprint = Fingerprint.sha1Fingerprint(key);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fingerprint.length(); i += 2) {
            sb.append(fingerprint.charAt(i));
            sb.append(fingerprint.charAt(i + 1));
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String sha1Fingerprint(byte[] bytes) {
        return Fingerprint.fingerprint(bytes, "SHA1");
    }

    public static String sha256Fingerprint(byte[] bytes) {
        return Fingerprint.fingerprint(bytes, "SHA-256");
    }

    public static String sha256Fingerprint(String input) {
        return Fingerprint.sha256Fingerprint(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String fingerprint(byte[] key, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.update(key);
            byte[] result = digest.digest();
            return Fingerprint.encodeHex(result);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static String encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS_UPPER[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS_UPPER[0xF & data[i]];
        }
        return new String(out);
    }
}

