/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import io.vavr.API;
import io.vavr.Function0;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.UsernameSearchResult;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoverIdpHelper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HostApp hostApp;
    private final UserLookupService userLookupService;
    private final IdpConfManager idpConfManager;

    public DiscoverIdpHelper(HostApp hostApp, UserLookupService userLookupService, IdpConfManager idpConfManager) {
        this.hostApp = hostApp;
        this.userLookupService = userLookupService;
        this.idpConfManager = idpConfManager;
    }

    List<IdpConfiguration> discoverIdpProviders(String username) {
        return ((Array)((Array)((Array)Array.ofAll(this.idpConfManager.getIdentityProviders()).filter(IdpConfiguration::isEnabled)).filter(configuration -> this.isMatchingKnownDomain(username, (IdpConfiguration)configuration) || this.isMatchingUserDirectory(username, (IdpConfiguration)configuration) || this.isMatchingUserGroup(username, (IdpConfiguration)configuration))).flatMap(configuration -> HashMap.of(configuration.getId(), configuration).values())).asJava();
    }

    boolean isMatchingKnownDomain(String maybeUsername, IdpConfiguration configuration) {
        return Option.of(maybeUsername).filter(_username -> configuration.getRedirectPolicy() == IdpConfiguration.RedirectPolicy.KNOWN_DOMAIN).map(username -> username.contains("@") ? username.substring(username.indexOf("@") + 1).toLowerCase() : null).map(domain -> this.isMatchingDomain((String)domain, configuration)).getOrElse(false);
    }

    boolean isMatchingUserDirectory(String maybeUsername, IdpConfiguration configuration) {
        return Option.of(maybeUsername).filter(_username -> configuration.getRedirectPolicy() == IdpConfiguration.RedirectPolicy.USER_DIRECTORY).map(this.hostApp::getDirectoryForUser).filter(Objects::nonNull).map(directoryForUser -> configuration.getMatchedUserDirectoryIds().contains(directoryForUser.getId())).getOrElse(false);
    }

    boolean isMatchingUserGroup(String maybeUsername, IdpConfiguration configuration) {
        UsernameSearchResult usernameSearchResult = Option.of(maybeUsername).filter(_username -> configuration.getRedirectPolicy() == IdpConfiguration.RedirectPolicy.USER_GROUP).flatMap(username -> this.getUsernameSearchResult((String)username, configuration)).filter(result -> Objects.nonNull(result.getDirectory())).getOrElse(UsernameSearchResult.notFound(null));
        return (Boolean)((Function0)API.Match(usernameSearchResult).of(API.Case(API.$(UsernameSearchResult::isResolved), usr -> API.Function(() -> Try.of(() -> usr).mapTry(result -> this.hostApp.getDirectoryManager().searchNestedGroupRelationships(result.getDirectory().getId().longValue(), this.getMembershipQuery(result.getUserProfile().getUsername()))).mapTry(userCurrentGroups -> this.isUserMemberOfAtLeastOneGroup((List<String>)userCurrentGroups, configuration.getRedirectGroups())).onFailure(e -> this.log.error(ErrorUtils.createErrorMessage("KSSO-9J6JGVLKLD", "Unable to resolve user group memberships while redirecting user to IDP during login."), e)).getOrElse(false))), API.Case(API.$(), usr -> API.Function(() -> false)))).apply();
    }

    private boolean isUserMemberOfAtLeastOneGroup(List<String> userCurrentGroups, Set<String> groups2) {
        return ((Array)((Array)Array.ofAll(userCurrentGroups).distinct()).filter(Objects::nonNull)).filter(groups2::contains).nonEmpty();
    }

    private boolean isMatchingDomain(String domain, IdpConfiguration configuration) {
        return Option.of(domain).filter(_domain -> configuration.isEnabled()).filter(_domain -> configuration.getRedirectPolicy() != IdpConfiguration.RedirectPolicy.NONE).filter(Objects::nonNull).map(_domain -> configuration.getKnownDomains().contains(_domain)).getOrElse(false);
    }

    @NotNull
    private Option<UsernameSearchResult> getUsernameSearchResult(String username, IdpConfiguration configuration) {
        return Option.ofOptional(this.userLookupService.searchUserAccount(username, configuration.getUserNotFoundPolicy(), configuration.getUserLookupAttribute(), false).stream().filter(r -> r.getResolvedUserPrincipalEntry() != null).findFirst());
    }

    private MembershipQuery<String> getMembershipQuery(String username) {
        return QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).startingAt(0).returningAtMost(-1);
    }
}

