/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.saml.CertGuiWrapper;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.IdpsConfigServlet;

@Scanned
public class CertsServlet
extends RequireAdminServlet {
    private final TemplateRenderer templateRenderer;
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;

    @Inject
    public CertsServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.templateRenderer = bucket.getTemplateRenderer();
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.idpConfManager.ensureKeysExist(req.getServerName());
        resp.setContentType("text/html");
        Map<String, Object> model = this.newModel(req);
        model.put("menuItem", "samlCerts");
        model.put("topMenu", "SAML");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("dateUtils", new IdpsConfigServlet.DateUtils());
        model.put("activeCert", new CertGuiWrapper(this.idpConfManager.parseCert(this.idpConfManager.getSigningCert()), this.idpConfManager.getSigningKeysDirectory()));
        model.put("standbyCerts", CertGuiWrapper.getList(this.idpConfManager.getStandbyCertificates(), this.idpConfManager.getSigningKeysDirectory()));
        model.put("downloadCertURL", this.idpConfManager.getSAMLRequestCertURL(req));
        model.put("keyPasswordSet", this.idpConfManager.getSamlPrivateKeyPassword() != null);
        this.checkSigningKeyPassword(model);
        this.templateRenderer.render("templates/saml/certs.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String hash;
        if (req.getParameter("addStandby") != null) {
            this.idpConfManager.addStandbyKey(req.getServerName());
        }
        if (req.getParameter("promoteCert") != null) {
            hash = req.getParameter("hash");
            this.idpConfManager.promoteActiveCertificate(hash);
        }
        if (req.getParameter("deleteCert") != null) {
            hash = req.getParameter("hash");
            this.idpConfManager.deleteCertificate(hash);
        }
        if (req.getParameter("update_password") != null) {
            String currentPassword = this.idpConfManager.getSamlPrivateKeyPassword();
            String newPassword = "use_random_password".equals(req.getParameter("encryption")) ? this.idpConfManager.generateSamlPrivateKeyPassword() : null;
            this.idpConfManager.updateSigningKeyPassword(currentPassword, newPassword);
            this.idpConfManager.setSamlPrivateKeyPassword(newPassword);
        }
        resp.sendRedirect("certs");
    }

    private void checkSigningKeyPassword(Map<String, Object> model) {
        model.put("invalidSigningKeyPassword", this.idpConfManager.isActiveSigningKeyDefined() && this.idpConfManager.getSpSigningCredential().getPrivateKey() == null);
        model.put("certsPage", true);
    }
}

