/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import io.vavr.control.Try;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.kantega.atlaskerb.saml.Fingerprint;

public class CertTool {
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";

    public static String unwrapCert(String certString) {
        int start = 0;
        int end = certString.length();
        if (certString.contains(BEGIN_CERTIFICATE)) {
            start = certString.indexOf(BEGIN_CERTIFICATE) + BEGIN_CERTIFICATE.length();
        }
        if (certString.contains(END_CERTIFICATE)) {
            end = certString.indexOf(END_CERTIFICATE);
        }
        return certString.substring(start, end).replace("\r\n", "").replace("\n", "");
    }

    public X509Certificate parse(String base64) {
        return this.parse(Base64.decodeBase64(base64));
    }

    public X509Certificate parse(byte[] certBytes) {
        try {
            CertificateFactory factory2 = CertificateFactory.getInstance("X509");
            return (X509Certificate)factory2.generateCertificate(new ByteArrayInputStream(certBytes));
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public String fingerPrint(byte[] certBytes) {
        return Try.of(() -> Fingerprint.formatSsha1Fingerprint(certBytes)).getOrElse("");
    }

    public String sha256FingerPrint(byte[] certBytes) {
        return Try.of(() -> Fingerprint.sha256Fingerprint(certBytes)).getOrElse("");
    }

    public int getKeySize(X509Certificate x509Certificate) {
        byte[] signature = x509Certificate.getSignature();
        if (signature == null) {
            return 0;
        }
        return signature.length * 8;
    }

    public String formatCertificate(String signingCert) {
        StringBuilder sb = new StringBuilder();
        sb.append(BEGIN_CERTIFICATE).append("\n");
        int lineLength = 50;
        for (int i = 0; i < signingCert.length(); i += lineLength) {
            String line = signingCert.substring(i, Math.min(signingCert.length(), i + lineLength));
            sb.append(line).append("\n");
        }
        sb.append(END_CERTIFICATE).append("\n");
        return sb.toString();
    }
}

