/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.OidcProcedureFactoryWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.InitiateOidcLogin;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCStateCache;
import org.kantega.atlaskerb.identityproviders.oidc.ResumeOidcLoginServlet;
import org.kantega.atlaskerb.saml.AtlSpServletSupport;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SAMLIdpConfiguration;
import org.kantega.atlaskerb.saml.util.ErrorPageRenderer;
import org.kantega.samllib.SpLoginServlet;
import org.kantega.samllib.spi.ServiceProviderSpi;

@Scanned
public class AtlSpLoginServlet
extends SpLoginServlet {
    private static final String PATH_POSTFIX = "/login";
    private static final String PATH_PREFIX = "/plugins/servlet/no.kantega.saml/sp/";
    private final UserManager userManager;
    private final AtlSpServletSupport atlSpServletSupport;
    private final ApplicationProperties applicationProperties;
    private final OIDCStateCache oidcStateCache;
    private final IdpConfManager idpConfManager;
    private final OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper;
    private final ErrorPageRenderer errorPageRenderer;

    @Inject
    public AtlSpLoginServlet(@ComponentImport UserManager userManager, AtlSpServletSupport atlSpServletSupport, ApplicationProperties applicationProperties, IdpConfManager idpConfManager, OIDCStateCache oidcStateCache, OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper, ErrorPageRenderer errorPageRenderer) {
        this.userManager = userManager;
        this.atlSpServletSupport = atlSpServletSupport;
        this.applicationProperties = applicationProperties;
        this.idpConfManager = idpConfManager;
        this.oidcStateCache = oidcStateCache;
        this.oidcProcedureFactoryWrapper = oidcProcedureFactoryWrapper;
        this.errorPageRenderer = errorPageRenderer;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Optional maybeIdpConfig = AtlSpServletSupport.getSpId(req, PATH_PREFIX, PATH_POSTFIX).flatMap(this.atlSpServletSupport::getIdpConfig);
        if (!maybeIdpConfig.isPresent()) {
            this.atlSpServletSupport.renderNotFound(req, resp);
        } else {
            IdpConfiguration idpConfig = (IdpConfiguration)maybeIdpConfig.get();
            if (idpConfig.isOIDC()) {
                OIDCIdpConfiguration oidcConfig = (OIDCIdpConfiguration)idpConfig;
                String callbackUrl = ResumeOidcLoginServlet.getCallbackUrl(this.applicationProperties);
                String loginHint = req.getParameter("username");
                String redirectTargetUrl = req.getParameter("target");
                Iterator knownDomainsIterator = idpConfig.getKnownDomains().iterator();
                String domainHint = null;
                if (idpConfig.isHostedDomain() && knownDomainsIterator.hasNext()) {
                    domainHint = (String)knownDomainsIterator.next();
                }
                if (StringUtils.isNotBlank(loginHint)) {
                    InitiateOidcLogin.run(req, resp, oidcConfig, this.idpConfManager, callbackUrl, loginHint, null, false, this.oidcStateCache, redirectTargetUrl, this.oidcProcedureFactoryWrapper, this.errorPageRenderer, this.userManager);
                } else {
                    InitiateOidcLogin.run(req, resp, oidcConfig, this.idpConfManager, callbackUrl, null, domainHint, false, this.oidcStateCache, redirectTargetUrl, this.oidcProcedureFactoryWrapper, this.errorPageRenderer, this.userManager);
                }
            } else {
                SAMLIdpConfiguration samlConfig = (SAMLIdpConfiguration)idpConfig;
                req.setAttribute("usePostBinding", (Object)samlConfig.isUsePostBinding());
                super.doGet(req, resp);
            }
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.getServiceProviderSpi(req) == null) {
            this.atlSpServletSupport.renderNotFound(req, resp);
        } else {
            super.doPost(req, resp);
        }
    }

    @Override
    protected ServiceProviderSpi getServiceProviderSpi(HttpServletRequest req) {
        return AtlSpServletSupport.getSpId(req, PATH_PREFIX, PATH_POSTFIX).flatMap(this.atlSpServletSupport::getServiceProviderSpi).orElse(null);
    }
}

