/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.restapi.access;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.json.JSONObject;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.restapi.access.RestrictAPIEndpoint;
import org.kantega.atlaskerb.restapi.access.TokenEndpointService;
import org.kantega.atlaskerb.utils.DatabaseUtils;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TokenEndpointServiceImpl
implements TokenEndpointService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ActiveObjects ao;
    private final HostApp hostApp;
    private final String REST;
    private final String baseUrl;
    private final String baseUrlURIPath;
    private final Cache<String, Object> oneMinuteCache;

    @Inject
    public TokenEndpointServiceImpl(@ComponentImport ActiveObjects activeObjects, @ComponentImport ApplicationProperties applicationProperties, HostAppFactory hostAppFactory) {
        this.ao = activeObjects;
        this.baseUrl = applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        this.baseUrlURIPath = Try.of(() -> new URI(this.baseUrl)).mapTry(URI::getPath).getOrElse("");
        this.hostApp = hostAppFactory.getInstance();
        this.REST = Try.of(() -> this.hostApp.isProductMatch("fecru") ? "/rest-service-fecru" : "/rest").getOrElse("");
        this.oneMinuteCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    }

    @Override
    public Either<Throwable, RestrictAPIEndpoint> addRestApiTokenEndpoint(String relativePath) {
        return this.sanitizeRelativePath(relativePath).onFailure(NullPointerException.class, throwable -> this.log.warn("Could not create API token restricted REST API endpoint: ", (Throwable)throwable)).filterTry(relPath -> this.findRestApiTokenEndpointByRelativePath((String)relPath).isEmpty(), _error -> new DuplicateEntryException("Could not save API token restricted REST API endpoint because the entry '" + this.tryBuildEntireUrlForRestEndpoint(relativePath) + "' is a duplicate.")).onFailure(DuplicateEntryException.class, duplicateEntryException -> this.log.warn(duplicateEntryException.getMessage())).mapTry(relPathValidated -> {
            String restPathValidated = (String)this.tryBuildRestPath((String)relPathValidated).filterTry(DatabaseUtils::isValidAOVarcharEntry).getOrElseThrow(() -> new IllegalArgumentException("Invalid input. Cannot save REST endpoint."));
            String entirePathValidated = (String)this.tryBuildEntireUrlForRestEndpoint((String)relPathValidated).filterTry(DatabaseUtils::isValidAOVarcharEntry).getOrElseThrow(() -> new IllegalArgumentException("Invalid input. Cannot save REST endpoint."));
            RestrictAPIEndpoint restApiRestrictedUrl = (RestrictAPIEndpoint)this.ao.create(RestrictAPIEndpoint.class, new DBParam[0]);
            restApiRestrictedUrl.setRelativePath((String)relPathValidated);
            restApiRestrictedUrl.setInternalPathRest(restPathValidated);
            restApiRestrictedUrl.setCompleteUrl(entirePathValidated);
            restApiRestrictedUrl.save();
            return restApiRestrictedUrl;
        }).onFailure(throwable -> this.log.warn("Failed to create API token restricted token endpoint: " + throwable)).onSuccess(restrictAPIEndpoint -> {
            this.log.info("Successfully restricted the REST API path '" + restrictAPIEndpoint.getCompleteUrl() + "' to API token authentication.");
            this.oneMinuteCache.invalidateAll();
        }).fold(Either::left, Either::right);
    }

    @Override
    public Try<String> tryBuildRestPath(String relPathValidated) {
        return Try.of(() -> HttpUrlUtils.sanitizeUrlForTrailingSlashes(this.REST.concat(relPathValidated)));
    }

    @Override
    public Try<String> tryBuildEntireUrlForRestEndpoint(String sanitizedRelativePath) {
        return Try.of(() -> this.REST.concat(sanitizedRelativePath)).mapTry(HttpUrlUtils::sanitizeUrlForTrailingSlashes).mapTry(this.baseUrl::concat);
    }

    @Override
    public Try<String> sanitizeRelativePath(String relativePath) {
        return HttpUrlUtils.tryNormalizeURI(relativePath).mapTry(URI::getPath).mapTry(uri -> HttpUrlUtils.stripPrefixFromUri(uri, this.baseUrlURIPath)).mapTry(uri -> HttpUrlUtils.stripPrefixFromUri(uri, this.REST)).mapTry(HttpUrlUtils::sanitizeUrlForTrailingSlashes).mapTry(subPath -> HttpUrlUtils.addPrefixIfNotInPath(subPath, "/")).filterTry(DatabaseUtils::isValidAOVarcharEntry);
    }

    @Override
    public boolean isAnyTokenEndpointsConfigured() {
        return !this.findAllRestApiTokenEndpoints().isEmpty();
    }

    @Override
    public void deleteRestApiTokenEndpoint(RestrictAPIEndpoint restApiRestrictedUrl) {
        try {
            this.ao.delete(new RawEntity[]{restApiRestrictedUrl});
            this.oneMinuteCache.invalidateAll();
        }
        catch (Exception e) {
            this.log.warn("Failed to delete restricted rest api url: " + e);
        }
    }

    @Override
    public List<RestrictAPIEndpoint> findAllRestApiTokenEndpoints() {
        return Try.of(() -> (io.vavr.collection.List)this.oneMinuteCache.get((Object)"allTokenEndpoints", () -> io.vavr.collection.List.of(this.ao.find(RestrictAPIEndpoint.class, Query.select().order("RELATIVE_PATH DESC"))))).onFailure(ExecutionException.class, t -> this.log.debug("Unexpected error fetching all Token Endpoints", (Throwable)t)).getOrElse(io.vavr.collection.List.empty()).asJava();
    }

    @Override
    public Option<RestrictAPIEndpoint> findRestApiTokenEndpointById(String id) {
        RestrictAPIEndpoint[] restApiRestrictedUrls = Try.of(() -> (RestrictAPIEndpoint[])this.ao.find(RestrictAPIEndpoint.class, Query.select().where("ID = ?", new Object[]{Integer.parseInt(id)}))).onFailure(throwable -> this.log.warn("Failed to read API Token restricted endpoint by ID from AO: " + throwable)).getOrElse(new RestrictAPIEndpoint[0]);
        if (restApiRestrictedUrls.length == 1) {
            return Option.of(restApiRestrictedUrls[0]);
        }
        return Option.none();
    }

    @Override
    public Option<RestrictAPIEndpoint> findRestApiTokenEndpointByRelativePath(String relativePath) {
        RestrictAPIEndpoint[] restApiRestrictedUrls = Try.of(() -> (RestrictAPIEndpoint[])this.ao.find(RestrictAPIEndpoint.class, Query.select().where("RELATIVE_PATH = ?", new Object[]{relativePath}))).onFailure(throwable -> this.log.warn("Failed to read API Token restricted endpoint by RELATIVE_PATH from AO: " + throwable)).getOrElse(new RestrictAPIEndpoint[0]);
        if (restApiRestrictedUrls.length == 1) {
            return Option.of(restApiRestrictedUrls[0]);
        }
        return Option.none();
    }

    @Override
    public String getAllEndpointsAsJson() {
        return Try.of(() -> {
            JSONObject allRestrictApiEndpoints = new JSONObject();
            List endpointsInJson = io.vavr.collection.List.ofAll(this.findAllRestApiTokenEndpoints()).map(endpoint -> JsonMapping.Write.objectAsJson(endpoint, RestrictAPIEndpoint.class).mapTry(JSONObject::toString).onFailure(throwable -> {
                throw new ErrorUtils.KssoException("Failed to write RestrictAPIEndpoint JSON", (Throwable)throwable);
            }).getOrElse("")).asJava();
            allRestrictApiEndpoints.put("allEndpoints", endpointsInJson);
            return allRestrictApiEndpoints.toString();
        }).onFailure(throwable -> this.log.warn(ErrorUtils.createErrorMessage("KSSO-LW1G74VNUK", "Could not transform restrict API Endpoints to JSON for backup: "), throwable)).getOrElse("");
    }

    @Override
    public void restoreEndpoints(Properties props) {
        try {
            String json = props.getProperty("restrictAPIEndpoints");
            List endpointsFromJson = JsonMapping.Write.stringAsJson(json).flatMapTry(JsonMapping.Read::mapFromJsonObject).mapTry(jsonObject -> jsonObject.get("allEndpoints")).mapTry(listOfTokens -> (ArrayList)listOfTokens).getOrElse(new ArrayList());
            this.restoreEndpoints(endpointsFromJson);
        }
        catch (Exception e) {
            this.log.warn(ErrorUtils.createErrorMessage("KSSO-V1I12GX3HG", "Unable to restore restrict API Endpoints from backup: "), (Throwable)e);
        }
    }

    private void restoreEndpoints(List<String> restoredEndpoints) {
        List<RestrictAPIEndpoint> endpoints = this.findAllRestApiTokenEndpoints();
        ArrayList<Try<Void>> tryList = new ArrayList<Try<Void>>();
        for (String json : restoredEndpoints) {
            tryList.add(this.addEndpointFromJson(json));
        }
        boolean someFailed = io.vavr.collection.List.ofAll(tryList).exists(Try::isFailure);
        if (!someFailed) {
            this.deleteEndpoints(endpoints);
        } else {
            this.log.error(ErrorUtils.createErrorMessage("KSSO-IHE64TJZPC", "Not deleting existing restrict API Endpoints since import of some failed from backup."));
        }
    }

    private void deleteEndpoints(List<RestrictAPIEndpoint> endpoints) {
        try {
            for (RestrictAPIEndpoint endpoint : endpoints) {
                this.ao.delete(new RawEntity[]{endpoint});
            }
        }
        catch (Exception e) {
            this.log.error(ErrorUtils.createErrorMessage("KSSO-E72CSMKWN7", "Could not delete restrict API Endpoints upon import from backup: "), (Throwable)e);
        }
    }

    private Try<Void> addEndpointFromJson(String json) {
        return Try.run(() -> {
            RestrictAPIEndpoint restrictAPIEndpoint = (RestrictAPIEndpoint)this.ao.create(RestrictAPIEndpoint.class, new DBParam[0]);
            JsonMapping.Write.stringAsJson(json).andThen(jsonObject -> JsonMapping.Read.populateInstanceFromJson(jsonObject, restrictAPIEndpoint, RestrictAPIEndpoint.class)).onFailure(throwable -> this.log.warn(ErrorUtils.createErrorMessage("KSSO-TPCPEAGFVI", "Failed to restore data from JSON: "), throwable));
            restrictAPIEndpoint.save();
        }).onFailure(e -> this.log.error(ErrorUtils.createErrorMessage("KSSO-7D2X7V21FY", "Unable to restore restrict API Endpoint from backup: "), e));
    }

    public static class DuplicateEntryException
    extends Exception {
        public DuplicateEntryException(String message) {
            super(message);
        }
    }
}

