/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.restapi.access;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.Tuple;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.restapi.access.RestrictAPIEndpoint;
import org.kantega.atlaskerb.restapi.access.TokenEndpointService;
import org.kantega.atlaskerb.restapi.access.TokenEndpointServiceImpl;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class RestrictApiAccessServlet
extends RequireAdminServlet {
    private final UserManager userManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final TokenEndpointService tokenEndpointService;
    private final KerbConfManager kerbConfManager;
    private final HostApp hostApp;
    private final String REST;
    private final Logger log = LoggerFactory.getLogger(RestrictApiAccessServlet.class);

    @Inject
    public RestrictApiAccessServlet(RequireAdminServletDependencyBucket bucket, TokenEndpointService tokenEndpointService) {
        super(bucket);
        this.userManager = bucket.getUserManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.tokenEndpointService = tokenEndpointService;
        this.kerbConfManager = bucket.getKerbConfManager();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.REST = this.hostApp.isProductMatch("fecru") ? "/rest-service-fecru" : "/rest";
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.buildModel(req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/rest-api-access.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String addRestrictedRestUrl;
        HashMap<String, Object> postModel = new HashMap<String, Object>();
        String isRestApiRestrictedToTokens = req.getParameter("isRestApiRestrictedToTokens");
        String isRestApiCompleteLockdown = req.getParameter("isRestApiCompleteLockdown");
        String setRestriction = req.getParameter("setRestriction");
        if (setRestriction != null) {
            this.kerbConfManager.setRestApiRestrictedToApiTokens("on".equals(isRestApiRestrictedToTokens), "on".equals(isRestApiCompleteLockdown));
            postModel.put("isRestApiRestrictedToTokens", "on".equals(isRestApiRestrictedToTokens));
        }
        if ((addRestrictedRestUrl = req.getParameter("addRestUrl")) != null) {
            this.tokenEndpointService.sanitizeRelativePath(addRestrictedRestUrl).onFailure(throwable -> {
                this.log.error("Could not save REST API token restricted REST API endpoint. Illegal input.", throwable);
                postModel.put("illegalInput", "Could not save '" + addRestrictedRestUrl + "'. Illegal input.");
            }).onSuccess(sanitizedRelativePath -> {
                String entireUrl = this.tokenEndpointService.tryBuildEntireUrlForRestEndpoint((String)sanitizedRelativePath).getOrElse("");
                this.tokenEndpointService.addRestApiTokenEndpoint((String)sanitizedRelativePath).mapLeft(throwable -> throwable instanceof TokenEndpointServiceImpl.DuplicateEntryException ? Tuple.of("addedEndpointError", "Duplicate entry. The url '" + entireUrl + "' has already been restriced.") : Tuple.of("addedEndpointError", "Something went wrong adding token endpoint: " + throwable.getMessage())).map(restrictAPIEndpoint -> "Successfully restricted " + entireUrl).peekLeft(left -> {
                    postModel.put((String)left._1(), left._2());
                    postModel.put("attemptedToSaveUrl", entireUrl);
                });
            });
        }
        Option.of(req.getParameter("removeRestUrl")).flatMap(this.tokenEndpointService::findRestApiTokenEndpointById).peek(this.tokenEndpointService::deleteRestApiTokenEndpoint);
        String errorPageMessage = req.getParameter("errorPageMessage");
        if (errorPageMessage != null) {
            this.kerbConfManager.setLockedRestApiErrorPageMessage(errorPageMessage);
        }
        this.buildModelAndRenderTemplate(req, resp, postModel);
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> additionalModelAttributes) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        model.putAll(additionalModelAttributes);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/rest-api-access.vm", model, (Writer)resp.getWriter());
    }

    private Map<String, Object> buildModel(HttpServletRequest req) {
        Map<String, Object> model = this.newModel(req);
        List<RestrictAPIEndpoint> restApiRestrictAPIEndpoints = this.tokenEndpointService.findAllRestApiTokenEndpoints();
        restApiRestrictAPIEndpoints.stream().filter(endpoint -> this.pathIndicatesEntireAPIClosed(endpoint.getInternalPathRest())).filter(_endpoint -> this.kerbConfManager.isRestApiCompleteLockdown()).findFirst().ifPresent(endpoint -> {
            model.put("warningClosedDownEntireApi", true);
            model.put("submittedURIWarningClosedDownEntireApi", endpoint.getCompleteUrl());
        });
        model.put("topMenu", "api-tokens");
        model.put("menuItem", "restrict-rest-api-to-token");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("actualBaseUrl", this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        model.put("isFecru", this.hostApp.isProductMatch("fecru"));
        model.put("isApiTokensEnabled", this.kerbConfManager.isApiTokensEnabled());
        model.put("isRestApiRestrictedToToken", this.kerbConfManager.isRestApiRestrictedToApiTokens());
        model.put("isRestApiCompleteLockdown", this.kerbConfManager.isRestApiCompleteLockdown());
        model.put("restrictionFilename", this.kerbConfManager.restApiRestrictedFilename);
        model.put("restrictedRestApiUrls", restApiRestrictAPIEndpoints);
        model.put("homeDirectory", this.kerbConfManager.getKerberosHomeDirectoryPath());
        model.put("errorPageMessageDefault", this.kerbConfManager.getTemplateLockedRestApiErrorPageMessage());
        model.put("errorPageMessage", this.kerbConfManager.getLockedRestApiErrorPageMessage());
        return model;
    }

    private boolean pathIndicatesEntireAPIClosed(String restPath) {
        return Option.of(restPath).map(HttpUrlUtils::sanitizeUrlForTrailingSlashes).map(path -> restPath.equals(this.REST) || restPath.equals(this.REST + "/api")).getOrElse(false);
    }
}

