/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.proxy;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

@Scanned
public class ProxyIpRuleServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final KerbConfManager kerbConfManager;
    private final HostApp hostApp;

    @Inject
    public ProxyIpRuleServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.userManager = bucket.getUserManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.buildModel(req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/ip-proxy-rule.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, Object> protoModel = new HashMap<String, Object>();
        String forwarded = req.getParameter("forwarded");
        if (forwarded != null) {
            this.kerbConfManager.setPreferredProxyHeader("YES".equals(forwarded) ? "x-forwarded-for" : null);
            this.buildModelAndRenderTemplate(req, resp, protoModel);
        }
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> protoModel) throws IOException {
        Map<String, Object> model = this.buildModel(req);
        model.putAll(protoModel);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/ip-proxy-rule.vm", model, (Writer)resp.getWriter());
    }

    private Map<String, Object> buildModel(HttpServletRequest req) {
        Map<String, Object> model = this.newModel(req);
        IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
        model.put("topMenu", "dashboard");
        model.put("menuItem", "api-tokens");
        model.put("displayName", this.applicationProperties.getDisplayName());
        String remoteIpAddress = this.kerbConfManager.getRemoteIpAddress(req);
        model.put("remoteIpAddress", remoteIpAddress);
        model.put("isRemoteAddressEnabled", ipRestrictionConfig.getApiTokenFilter().isRemoteAddressEnabled(remoteIpAddress));
        model.put("isProxied", this.kerbConfManager.getPreferredProxyHeader() != null);
        model.put("userIP", req.getRemoteAddr());
        model.put("xForwardedFor", req.getHeader("X-Forwarded-For"));
        model.put("hasRemoteIpValve", HttpUrlUtils.isRemoteIpValveConfigured());
        return model;
    }
}

