/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.keytab;

import java.util.Arrays;
import java.util.List;

public class PrincipalName {
    private final String realm;
    private final List<String> components;
    private final int nameType;

    public PrincipalName(String realm, List<String> components, int nameType) {
        this.realm = realm;
        this.components = components;
        this.nameType = nameType;
    }

    public static PrincipalName parse(String name, int nameType) {
        String realm = name.substring(name.indexOf("@") + 1);
        String names = name.substring(0, name.indexOf("@"));
        return new PrincipalName(realm, Arrays.asList(names.split("/")), nameType);
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        for (String component : this.components) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(component);
        }
        sb.append("@").append(this.realm);
        return sb.toString();
    }

    public int getNameType() {
        return this.nameType;
    }

    public List<String> getComponents() {
        return this.components;
    }

    public String getRealm() {
        return this.realm;
    }
}

