/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc.evaluation;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.AttributeInfo;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluator;
import org.kantega.atlaskerb.identityproviders.UserProperty;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.evaluation.OIDCResponseEvaluationResult;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OIDCResponseEvaluator
extends ResponseEvaluator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Inject
    public OIDCResponseEvaluator(@ComponentImport UserManager userManager, HostAppFactory hostAppFactory, UserLookupService userLookupService) {
        super(userLookupService, userManager, hostAppFactory.getInstance());
    }

    public Either<String, OIDCResponseEvaluationResult> evaluate(OIDCIdpConfiguration idpConfiguration, JSONObject profile, IdpConfiguration.UsernameAttribute usernameAttribute, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, String nameAttribute, String emailAttribute, String customUsernameAttributeName, boolean addDefaultGroups) {
        List<AttributeInfo> attributeInfos = OIDCResponseEvaluator.getAttributeInfos(profile);
        OIDCResponseEvaluationResult result = new OIDCResponseEvaluationResult(idpConfiguration, attributeInfos, usernameAttribute, customUsernameAttributeName, userLookupAttribute, userLookupTransform);
        Either<String, UserRecipe> maybeUserRecipe = this.findUserRecipe(profile, result, nameAttribute, emailAttribute);
        if (maybeUserRecipe.isLeft()) {
            return Either.left(maybeUserRecipe.getLeft());
        }
        return this.evaluateResult(idpConfiguration, result, userLookupAttribute, userLookupTransform, maybeUserRecipe.get(), addDefaultGroups).mapTry(OIDCResponseEvaluationResult.class::cast).fold(throwable -> Either.left(ErrorUtils.createErrorMessage("KSSO-R3ZH73DXRH", "Failed to evaluate OIDC response: " + throwable.getMessage())), Either::right);
    }

    private Either<String, UserRecipe> findUserRecipe(JSONObject profileJson, OIDCResponseEvaluationResult result, String nameAttribute, String emailAttribute) {
        if (Option.of(result).isEmpty()) {
            return Either.left(ErrorUtils.createErrorMessage("KSSO-WO2FBW6GQS", "Could not find response evaluation result."));
        }
        if (Option.of(profileJson).isEmpty()) {
            return Either.left(ErrorUtils.createErrorMessage("KSSO-Y86V7LN2MP", "Invalid JSON while finding user recipe."));
        }
        Option<AttributeInfo> maybeConfiguredAttributeInfo = Option.of(result.getConfiguredUsernameAttributeInfo());
        String searchedUsername = result.getSearchedUsername();
        if (maybeConfiguredAttributeInfo.isEmpty()) {
            return Either.left(ErrorUtils.createErrorMessage("KSSO-DI9HFISO0R", "Failed to find configured username attribute."));
        }
        UserProperty username = (UserProperty)maybeConfiguredAttributeInfo.map(attributeInfo -> new UserProperty(attributeInfo.getId(), searchedUsername)).get();
        UserProperty name = null;
        if (StringUtils.isNotBlank(nameAttribute) && profileJson.has(nameAttribute) && profileJson.get(nameAttribute) != null) {
            name = new UserProperty(nameAttribute, OIDCResponseEvaluator.getFirstInJSONArrayIfKeyContainsEmail(profileJson, nameAttribute));
        }
        UserProperty email = null;
        if (StringUtils.isNotBlank(emailAttribute) && profileJson.has(emailAttribute) && profileJson.get(emailAttribute) != null) {
            email = new UserProperty(emailAttribute, OIDCResponseEvaluator.getFirstInJSONArrayIfKeyContainsEmail(profileJson, emailAttribute));
        }
        return Either.right(new UserRecipe(username, name, email));
    }

    private static String getFirstInJSONArrayIfKeyContainsEmail(JSONObject profileJson, String key) {
        Object value = profileJson.get(key);
        if (StringUtils.containsIgnoreCase(key, "email") && value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            value = array.get(0);
        }
        return value.toString();
    }

    public Set<String> findOidcGroups(JSONObject profileJson, Set<String> groupsParameters) {
        HashSet<String> result = new HashSet<String>();
        for (String param : groupsParameters) {
            try {
                List<Object> groups2 = profileJson.getJSONArray(param).toList();
                for (Object group : groups2) {
                    result.add(group.toString());
                }
            }
            catch (JSONException e) {
            }
        }
        return result;
    }

    public static List<AttributeInfo> getAttributeInfos(JSONObject profileJson) {
        ArrayList<AttributeInfo> attributeInfos = new ArrayList<AttributeInfo>();
        for (String key : profileJson.keySet()) {
            String value = OIDCResponseEvaluator.getFirstInJSONArrayIfKeyContainsEmail(profileJson, key);
            if (key.equals("id_token")) continue;
            try {
                attributeInfos.add(new AttributeInfo(key, value, IdpConfiguration.UsernameAttribute.valueOf(key.toUpperCase())));
            }
            catch (IllegalArgumentException e) {
                attributeInfos.add(new AttributeInfo(key, value, IdpConfiguration.UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME));
            }
        }
        return attributeInfos;
    }
}

