/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.json.JSONObject;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OIDCStateCache {
    private static final String CACHE_KEY = "oidcStateCache";
    private final Cache<String, String> oidcStateCache;
    private static final Logger log = LoggerFactory.getLogger(OIDCStateCache.class);

    @Inject
    public OIDCStateCache(@ComponentImport CacheManager cacheManager) {
        this.oidcStateCache = cacheManager.getCache(CACHE_KEY, null, new CacheSettingsBuilder().remote().replicateViaCopy().replicateAsynchronously().expireAfterWrite(30L, TimeUnit.MINUTES).maxEntries(Integer.parseInt(System.getProperty(CACHE_KEY, "25000"))).build());
    }

    public void put(String stateKey, ResumeState resumeState) {
        JsonMapping.Write.objectAsJson(resumeState).mapTry(JSONObject::toString).flatMapTry(jsonString -> Try.run(() -> this.oidcStateCache.put((Object)stateKey, jsonString))).onFailure(throwable -> log.error(ErrorUtils.createErrorMessage("KSSO-IKJT1K9JTJ", "Could not resume OIDC login process. Stacktrace: " + throwable)));
    }

    public Option<ResumeState> pop(String stateKey) {
        return Try.of(() -> (String)this.oidcStateCache.get((Object)stateKey)).onSuccess(_stateValue -> this.oidcStateCache.remove((Object)stateKey)).flatMapTry(json -> JsonMapping.Read.valueFromJson(json, ResumeState.class)).onFailure(throwable -> log.error(ErrorUtils.createErrorMessage("KSSO-MMEVWSVUN4", "Could not resume OIDC login process. Stacktrace: " + throwable))).toOption();
    }

    @JsonMapping.JsonMapper
    public static final class ResumeState {
        private final String idpId;
        String oidcProcedureDataJSONString;
        private final boolean test;
        private final String targetUrl;

        ResumeState() {
            this.idpId = null;
            this.oidcProcedureDataJSONString = null;
            this.test = false;
            this.targetUrl = null;
        }

        public ResumeState(@JsonMapping.JsonProperty(value="idpId") String idpId, @JsonMapping.JsonProperty(value="oidcProcedureDataJSONString") String oidcProcedureDataJSONString, @JsonMapping.JsonProperty(value="test") boolean test, @JsonMapping.JsonProperty(value="targetUrl") String targetUrl) {
            this.idpId = idpId;
            this.oidcProcedureDataJSONString = oidcProcedureDataJSONString;
            this.test = test;
            this.targetUrl = targetUrl;
        }

        public String getIdpId() {
            return this.idpId;
        }

        public String getOidcProcedureDataJSONString() {
            return this.oidcProcedureDataJSONString;
        }

        public boolean isTest() {
            return this.test;
        }

        public String getTargetUrl() {
            return this.targetUrl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResumeState that = (ResumeState)o;
            return this.test == that.test && Objects.equals(this.idpId, that.idpId) && Objects.equals(this.targetUrl, that.targetUrl) && Objects.equals(this.oidcProcedureDataJSONString, that.oidcProcedureDataJSONString);
        }

        public int hashCode() {
            return Objects.hash(this.test, this.oidcProcedureDataJSONString, this.idpId, this.targetUrl);
        }
    }
}

