/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.kantegasso.oidc.OidcProcedureData;
import io.vavr.collection.HashMap;
import io.vavr.control.Either;
import io.vavr.control.Option;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.OidcProcedureFactoryWrapper;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCIdpConfiguration;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitiateOidcLogout {
    private static final Logger log = LoggerFactory.getLogger(InitiateOidcLogout.class);

    public static String run(OIDCIdpConfiguration oidcIdpConfiguration, ApplicationProperties appProps, OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper, HostApp hostApp) {
        Either maybeInitiateSingleLogout = oidcProcedureFactoryWrapper.createOidcProcedure(HashMap.of("client_id", oidcIdpConfiguration.getClientId(), "client_secret", oidcIdpConfiguration.getClientSecret(), "workaround", oidcIdpConfiguration.getKind().getOidcLibRepresentation(), "discovery_url", oidcIdpConfiguration.getDiscoveryUrl(), "post_logout_redirect_uri", oidcIdpConfiguration.getSingleLogoutReturnURL())).flatMap(data -> data.get("discovery_url").filter(StringUtils::isNotBlank).isDefined() ? data.discover() : Either.right(data)).peekLeft(errorMessage -> log.error(ErrorUtils.createErrorMessage("KSSO-0B21TH9KN4", "Error Single logout. Error message trying to do discovery: " + errorMessage))).flatMap(OidcProcedureData::initiateSingleLogout).peekLeft(errorMessage -> log.error(ErrorUtils.createErrorMessage("KSSO-YCEOOA9BJF", "Error Single logout, something went wrong contacting the IdP: " + errorMessage)));
        if (maybeInitiateSingleLogout.isLeft()) {
            return appProps.getBaseUrl(UrlMode.ABSOLUTE) + hostApp.getLogoutPage();
        }
        Option<String> maybeLogoutUri = ((OidcProcedureData)maybeInitiateSingleLogout.get()).getLogoutUri();
        if (maybeLogoutUri.isEmpty()) {
            log.error(ErrorUtils.createErrorMessage("KSSO-3GE7FDW3ZC", "Single logout: Could not find logout URI."));
            return appProps.getBaseUrl(UrlMode.ABSOLUTE) + hostApp.getLogoutPage();
        }
        if (!HttpUrlUtils.isValidAndNonEmptyUri(maybeLogoutUri.get())) {
            log.error(ErrorUtils.createErrorMessage("KSSO-EOEMVOWFUJ", "Single logout: Invalid logout URI."));
            return appProps.getBaseUrl(UrlMode.ABSOLUTE) + "/Secure/Logout!default.jspa";
        }
        return maybeLogoutUri.get();
    }
}

