/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders.oidc;

import com.atlassian.sal.api.user.UserManager;
import com.kantegasso.oidc.OidcProcedureData;
import io.vavr.Value;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.identityproviders.OidcProcedureFactoryWrapper;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCIdpConfiguration;
import org.kantega.atlaskerb.identityproviders.oidc.OIDCStateCache;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.util.ErrorPageRenderer;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.kantega.atlaskerb.utils.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitiateOidcLogin {
    private static final Logger log = LoggerFactory.getLogger(InitiateOidcLogin.class);

    public static String run(HttpServletRequest req, HttpServletResponse resp, OIDCIdpConfiguration idpConfig, IdpConfManager idpConfManager, String callbackUrl, String loginHint, String domainHint, boolean prepareTestUrl, OIDCStateCache cache, String targetUrl, OidcProcedureFactoryWrapper oidcProcedureFactoryWrapper, ErrorPageRenderer errorPageRenderer, UserManager userManager) throws IOException {
        boolean isTest = TestUtils.isTest(req);
        List scopes = Option.of(idpConfig.getScopes()).map(List::ofAll).getOrElse(List.empty());
        Either<String, OidcProcedureData> maybeOidcProcedureDataInit = oidcProcedureFactoryWrapper.createOidcProcedure(HashMap.of("client_id", idpConfig.getClientId(), "client_secret", idpConfig.getClientSecret(), "discovery_url", idpConfig.getDiscoveryUrl(), "redirect_uri", callbackUrl, "workaround", idpConfig.getKind().getOidcLibRepresentation(), "login_hint", loginHint, "domain_hint", domainHint, "issuer_allowlist", idpConfig.getIssuerAllowList())).peek(oidcProcedureData -> {
            if (isTest && oidcProcedureData.get("state").isDefined()) {
                idpConfManager.recordOIDCTestStarted(idpConfig.getId(), targetUrl, (OidcProcedureData)oidcProcedureData, oidcProcedureData.get("state").get());
            }
        }).peekLeft(errorMessage -> log.error(ErrorUtils.createErrorMessage("KSSO-8S2JI6BDXO", "Error initiating OIDC login. Error message creating OIDC config: " + errorMessage)));
        Option<String> maybeTestId = maybeOidcProcedureDataInit.toOption().flatMap(data -> data.get("state")).filter(_id -> isTest);
        Either<String, OidcProcedureData> maybeOidcProcedureData = maybeOidcProcedureDataInit.flatMap(data -> data.get("discovery_url").filter(StringUtils::isNotBlank).isDefined() ? data.discover() : Either.right(data)).peekLeft(leftMessage -> log.error(ErrorUtils.createErrorMessage("KSSO-1GNF5BZ2F9", "Error initiating OIDC login trying to do discovery: " + leftMessage))).flatMap(data -> data.authentication(scopes)).peekLeft(leftMessage -> {
            ErrorUtils.KssoError kssoError = ErrorUtils.createKssoError("KSSO-0B21TH9KN4", "Error initiating OIDC login trying to do OIDC authentication: " + leftMessage);
            log.error(kssoError.asMessage());
            if (isTest) {
                TestUtils.recordTestFailedBeforeRequest(idpConfig, idpConfManager, maybeOidcProcedureDataInit, maybeTestId, kssoError, ResponseEvaluationCode.FAILED_OIDC_INITIATE_LOGIN).onFailure(error -> log.warn(ErrorUtils.createErrorMessage("KSSO-F8CMRH6DG1", "Error recording test result: " + error.getMessage())));
            }
        });
        if (maybeOidcProcedureData.isLeft()) {
            if (isTest && maybeTestId.isDefined()) {
                TestUtils.renderTestResult(req, resp, idpConfig, idpConfManager, userManager, maybeTestId.get());
            } else {
                if (prepareTestUrl) {
                    return "";
                }
                String message = ErrorUtils.createErrorMessage("KSSO-0B21TH9KN4", "Error initiating OIDC login. " + maybeOidcProcedureData.getLeft());
                errorPageRenderer.renderError(Response.Status.BAD_REQUEST, message, req.getRequestURI(), resp);
            }
            return "";
        }
        OidcProcedureData oidcProcedureData2 = (OidcProcedureData)maybeOidcProcedureData.get();
        String authorizationUrl = oidcProcedureData2.get("authorization_url").getOrElse("");
        Value maybeResumeState = oidcProcedureData2.dataAsJSONString().map(oidcDataJson -> new OIDCStateCache.ResumeState(idpConfig.getId(), (String)oidcDataJson, isTest, targetUrl));
        Option<String> maybeStateKey = oidcProcedureData2.get("state");
        if (maybeStateKey.isEmpty() || maybeResumeState.isLeft()) {
            ErrorUtils.KssoError kssoError = ErrorUtils.createKssoError("KSSO-8P1Y6WQJ3E", "Failed to save OIDC state cache. State isDefined: " + maybeStateKey.isDefined() + ", Resume cache isDefined: " + maybeResumeState.isRight());
            log.error(kssoError.asMessage());
            if (isTest && maybeTestId.isDefined()) {
                TestUtils.recordTestFailedBeforeRequest(idpConfig, idpConfManager, maybeOidcProcedureData, maybeTestId, kssoError, ResponseEvaluationCode.FAILED_OIDC_INITIATE_LOGIN).onFailure(throwable -> log.warn(ErrorUtils.createErrorMessage("KSSO-NU9LQSF7IB", "Error recording test result: " + throwable.getMessage())));
                TestUtils.renderTestResult(req, resp, idpConfig, idpConfManager, userManager, maybeTestId.get());
            } else if (prepareTestUrl) {
                return "";
            }
            errorPageRenderer.renderError(Response.Status.BAD_REQUEST, kssoError.asMessage(), req.getRequestURI(), resp);
            return "";
        }
        cache.put(maybeStateKey.get(), (OIDCStateCache.ResumeState)maybeResumeState.get());
        if (isTest) {
            TestUtils.recordTestProcedureBeforeRequest(idpConfig, idpConfManager, maybeOidcProcedureData, maybeTestId, ResponseEvaluationCode.WAITING_FOR_RESPONSE);
        } else if (prepareTestUrl) {
            return authorizationUrl;
        }
        resp.sendRedirect(authorizationUrl);
        return authorizationUrl;
    }
}

