/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import io.vavr.control.Try;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.UserMappingUtils;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.FederatedIdentityResponseEvaluationResult;
import org.kantega.atlaskerb.identityproviders.GroupEvaluation;
import org.kantega.atlaskerb.identityproviders.GroupResult;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.ManagedGroup;
import org.kantega.atlaskerb.identityproviders.UserRecipe;
import org.kantega.atlaskerb.identityproviders.UsernameSearchResult;
import org.kantega.atlaskerb.identityproviders.saml.evaluation.SAMLResponseEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResponseEvaluator {
    protected final UserLookupService userLookupService;
    protected final UserManager userManager;
    protected final HostApp hostApp;
    private Logger log = LoggerFactory.getLogger(SAMLResponseEvaluator.class);

    public ResponseEvaluator(UserLookupService userLookupService, @ComponentImport UserManager userManager, HostApp hostApp) {
        this.userLookupService = userLookupService;
        this.hostApp = hostApp;
        this.userManager = userManager;
    }

    public Try<? extends FederatedIdentityResponseEvaluationResult> evaluateResult(IdpConfiguration idpConfiguration, FederatedIdentityResponseEvaluationResult result, IdpConfiguration.UserLookupAttribute userLookupAttribute, IdpConfiguration.UserLookupTransform userLookupTransform, UserRecipe userRecipe, boolean addDefaultGroups) {
        return Try.of(() -> {
            if (result.isConfiguredUsernameAttributeFound()) {
                String searchedUsername;
                String idpUsername = result.getConfiguredUsernameAttributeInfo().getValue();
                String userDomain = idpUsername.contains("@") ? idpUsername.substring(idpUsername.indexOf("@") + 1).toLowerCase() : null;
                result.setDomainAllowed(idpConfiguration.isDomainAllowed(userDomain));
                result.setUserDomain(userDomain);
                if (userLookupTransform == IdpConfiguration.UserLookupTransform.NAME_PART) {
                    String namePart = idpUsername;
                    if (idpUsername.contains("@")) {
                        namePart = idpUsername.substring(0, idpUsername.indexOf("@"));
                    }
                    searchedUsername = namePart;
                } else {
                    searchedUsername = userLookupTransform == IdpConfiguration.UserLookupTransform.REGEX ? UserMappingUtils.transformUsername(idpUsername, idpConfiguration.getUserTransformationRegexes()).orElse(idpUsername) : idpUsername;
                }
                result.setSearchedUsername(searchedUsername);
                List<UsernameSearchResult> searchResults = this.userLookupService.searchUserAccount(searchedUsername, idpConfiguration.getUserNotFoundPolicy(), userLookupAttribute, addDefaultGroups);
                result.setSearchResult(searchResults);
                Optional<UsernameSearchResult> first = searchResults.stream().filter(r -> r.getResolvedUserPrincipalEntry() != null).findFirst();
                if (first.isPresent()) {
                    UsernameSearchResult usernameSearchResult = first.get();
                    result.setResolvedPrincipalEntry(usernameSearchResult.getResolvedUserPrincipalEntry());
                    result.setUserProfile(usernameSearchResult.getUserProfile());
                    Directory directory = usernameSearchResult.getDirectory();
                    result.setReadOnlyDirectory(directory != null && !directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP));
                    result.setResolvedUserDirectory(usernameSearchResult.getDirectory());
                }
                if (idpConfiguration.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE || idpConfiguration.getUserUpdatePolicy() == IdpConfiguration.UserUpdatePolicy.UPDATE) {
                    userRecipe.getUsername().setValue(searchedUsername);
                    result.setUserRecipe(userRecipe);
                }
            }
            return result;
        });
    }

    public void evaluateGroups(String username, List<ManagedGroup> managedGroups, Set<String> idpGroups, GroupEvaluation groupEvaluation, boolean createAllIncomingGroups) {
        groupEvaluation.setAllIdpGroupNames(idpGroups);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Evaluating Groups. Managed[{}] SAML[{}]", (Object)managedGroups.stream().map(mg -> String.format("'%s'", mg.getName())).collect(Collectors.joining(",")), (Object)idpGroups.stream().map(sg -> String.format("'%s'", sg)).collect(Collectors.joining(",")));
        }
        for (ManagedGroup group : managedGroups) {
            GroupResult groupResult = new GroupResult(group.getName(), idpGroups.contains(group.getName()), this.hostApp.isExistingGroup(group.getName()), this.hostApp.isUserInGroup(username, group.getName()));
            groupEvaluation.addManagedGroups(groupResult);
            this.log.debug("GroupResult: {}", (Object)groupResult);
        }
        HashSet<String> managedGroupNames = new HashSet<String>();
        for (ManagedGroup group : managedGroups) {
            managedGroupNames.add(group.getName());
        }
        for (String idpGroup : idpGroups) {
            if (!this.hostApp.isExistingGroup(idpGroup)) {
                groupEvaluation.addUnknownIdpGroup(idpGroup);
                if (!createAllIncomingGroups) continue;
                this.hostApp.addGroup(idpGroup);
                continue;
            }
            if (managedGroupNames.contains(idpGroup)) continue;
            groupEvaluation.addUnmanagedIdpGroup(idpGroup);
        }
    }
}

