/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.GroupResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupEvaluation {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Set<String> allIdpGroupNames;
    private final List<GroupResult> managedGroups = new ArrayList<GroupResult>();
    private final Set<String> unmanagedIdpGroups = new TreeSet<String>();
    private Set<String> unknownIdpGroups = new TreeSet<String>();

    public Set<String> getAllIdpGroupNames() {
        return this.allIdpGroupNames;
    }

    public void setAllIdpGroupNames(Set<String> allIdpGroupNames) {
        this.allIdpGroupNames = allIdpGroupNames;
    }

    public void addManagedGroups(GroupResult groupResult) {
        this.managedGroups.add(groupResult);
    }

    public List<GroupResult> getManagedGroups() {
        return this.managedGroups;
    }

    public void addUnmanagedIdpGroup(String idpGroup) {
        this.unmanagedIdpGroups.add(idpGroup);
    }

    public void addUnknownIdpGroup(String group) {
        this.unknownIdpGroups.add(group);
    }

    public Set<String> getUnknownIdpGroups() {
        return this.unknownIdpGroups;
    }

    public Set<String> getUnmanagedIdpGroups() {
        return this.unmanagedIdpGroups;
    }

    private Set<String> getGroupAdds() {
        if (this.managedGroups.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> adds = new HashSet<String>();
        for (GroupResult result : this.managedGroups) {
            if (result.isUserInGroup() || !result.isIdpGroupMember()) continue;
            adds.add(result.getName());
        }
        return adds;
    }

    private Set<String> getGroupRemoves() {
        if (this.managedGroups.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> removes = new HashSet<String>();
        for (GroupResult result : this.managedGroups) {
            if (!result.isUserInGroup() || result.isIdpGroupMember()) continue;
            removes.add(result.getName());
        }
        return removes;
    }

    public boolean syncUserIdpGroups(HostApp hostApp, Principal principal, boolean removeNonIdpGroupsFromUser, Set<String> defaultGroups) {
        boolean failing = false;
        for (String group : this.allIdpGroupNames) {
            if (hostApp.addUserToGroup(principal, group)) continue;
            failing = true;
        }
        if (removeNonIdpGroupsFromUser) {
            this.allIdpGroupNames.addAll(defaultGroups);
            failing = hostApp.removeNonIdpGroupsFromUser(principal, this.allIdpGroupNames);
        }
        return failing;
    }

    public boolean setManagedGroups(HostApp hostApp, Principal principal) {
        for (String group : this.getGroupAdds()) {
            if (hostApp.addUserToGroup(principal, group)) continue;
            return false;
        }
        for (String group : this.getGroupRemoves()) {
            if (hostApp.removeUserFromGroup(principal, group)) continue;
            return false;
        }
        return true;
    }

    public boolean setDefaultGroups(HostApp hostApp, Principal principal, Set<String> getDefaultGroups) {
        for (String group : getDefaultGroups) {
            try {
                if (hostApp.isUserInGroup(principal.getName(), group)) continue;
                hostApp.addUserToGroup(principal, group);
            }
            catch (Exception e) {
                this.log.warn("Assigning default groups at login. Could not assign {} to {}. Error: {}", new Object[]{principal.getName(), group, e.getMessage()});
                return false;
            }
        }
        return true;
    }
}

