/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.identityproviders;

import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;

public class AttributeInfo {
    private final String name;
    private final String value;
    private IdpConfiguration.UsernameAttribute usernameAttribute;

    public AttributeInfo(String name, String value, IdpConfiguration.UsernameAttribute usernameAttribute) {
        this.name = name;
        this.value = value;
        this.usernameAttribute = usernameAttribute;
    }

    public AttributeInfo(String name, String value) {
        this.name = name;
        this.value = value;
        this.usernameAttribute = null;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public IdpConfiguration.UsernameAttribute getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public String getId() {
        if (this.getName() != null) {
            return this.getName();
        }
        if (this.getUsernameAttribute() != null) {
            return this.getUsernameAttribute().name();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.getName() != null) {
            return this.getName();
        }
        if (this.getUsernameAttribute() != null) {
            return this.getUsernameAttribute().getDisplayName();
        }
        return null;
    }

    public static IdpConfiguration.UsernameAttribute getUsernameAttributeOf(String attributeName) {
        try {
            return IdpConfiguration.UsernameAttribute.valueOf(StringUtils.upperCase(attributeName));
        }
        catch (IllegalArgumentException e) {
            return IdpConfiguration.UsernameAttribute.CUSTOM_SAML_ATTRIBUTE_NAME;
        }
    }
}

