/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.DelegatedAuthenticationDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DbCachingRemoteDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.DelegatedAuthenticationDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.event.user.UserAuthenticatedEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import io.prometheus.client.Summary;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.IpRestrictionFilter;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.diagnostics.metrics.KSSOPluginMetrics;
import org.kantega.atlaskerb.hostapp.DefaultRemoteUserUpdater;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.RemoteUserUpdater;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.utils.CryptoUtils;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DefaultHostApp
implements HostApp {
    private static final Logger log = LoggerFactory.getLogger(DefaultHostApp.class);
    private static final String KSSO_SAML_JIT = "ksso.saml.jit";
    protected final java.util.List<String> preemptivePathMappings = new ArrayList<String>();
    private final DelegatedAuthenticationDirectoryInstanceLoader delegatedInstanceLoader;
    private final ApplicationService applicationService;
    private final DirectoryManager directoryManager;
    private final RemoteUserUpdater remoteUserUpdater;
    protected boolean hasRestApi;
    final TransactionTemplate transactionTemplate;
    final KerbConfManager kerbConfManager;
    final ApplicationProperties applicationProperties;
    final AuthenticationListener authenticationListener;
    final AuthenticationController authenticationController;
    final EventPublisher eventPublisher;
    final SafeRedirect safeRedirect;
    final CrowdDirectoryService crowdDirectoryService;
    final CrowdService crowdService;

    public DefaultHostApp(TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, AuthenticationListener authenticationListener, EventPublisher eventPublisher, AuthenticationController authenticationController, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, SafeRedirect safeRedirect, KerbConfManager kerbConfManager) {
        this.transactionTemplate = transactionTemplate;
        this.delegatedInstanceLoader = this.findComponent(DelegatedAuthenticationDirectoryInstanceLoader.class);
        this.applicationService = this.findComponent(ApplicationService.class);
        this.directoryManager = this.findComponent(DirectoryManager.class);
        this.remoteUserUpdater = new DefaultRemoteUserUpdater(this.findComponent(DbCachingRemoteDirectoryInstanceLoader.class));
        this.kerbConfManager = kerbConfManager;
        this.applicationProperties = applicationProperties;
        this.authenticationListener = authenticationListener;
        this.eventPublisher = eventPublisher;
        this.authenticationController = authenticationController;
        this.safeRedirect = safeRedirect;
        this.crowdDirectoryService = crowdDirectoryService;
        this.crowdService = crowdService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optionallyUpdateUserFromRemoteDirectory(String username, Directory directory, boolean isNewlyCreatedUser) throws OperationFailedException, UserNotFoundException, InactiveAccountException {
        Summary.Timer timer = KSSOPluginMetrics.optionalUserUpdateLatency.startTimer();
        try {
            boolean doUpdate;
            boolean bl = doUpdate = this.isAlwaysSyncGroups(directory) || this.isSyncGroupsOnFirstCreated(directory) && isNewlyCreatedUser;
            if (doUpdate && (directory.getType() == DirectoryType.CROWD || directory.getType() == DirectoryType.CONNECTOR)) {
                this.remoteUserUpdater.updateUser(username, directory, this);
            }
        }
        finally {
            timer.observeDuration();
        }
    }

    @Override
    public boolean isAlwaysSyncGroups(Directory directory) {
        return "true".equalsIgnoreCase((String)directory.getAttributes().get("crowd.sync.group.membership.after.successful.user.auth.enabled"));
    }

    @Override
    public boolean isSyncGroupsOnFirstCreated(Directory directory) {
        return "only_when_first_created".equalsIgnoreCase((String)directory.getAttributes().get("crowd.sync.group.membership.after.successful.user.auth.enabled"));
    }

    @Override
    public boolean createDelegatedUser(Directory directory, String username) {
        try {
            DelegatedAuthenticationDirectory remote = (DelegatedAuthenticationDirectory)this.getDelegatedInstanceLoader().getDirectory(directory);
            this.addOrUpdateLdapUser(username, remote);
            return true;
        }
        catch (UserNotFoundException e) {
            log.debug("Delegated user not created for user/lookupname '{}'", (Object)username, (Object)e);
            return false;
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOrUpdateLdapUser(String username, DelegatedAuthenticationDirectory remote) throws UserNotFoundException, OperationFailedException {
        Thread ct = Thread.currentThread();
        ClassLoader oldCcl = ct.getContextClassLoader();
        try {
            ct.setContextClassLoader(CrowdService.class.getClassLoader());
            remote.addOrUpdateLdapUser(username);
        }
        catch (UserNotFoundException u) {
            log.debug("User not found in this delegated directory which is expected if users is removed by filter", (Throwable)u);
        }
        finally {
            ct.setContextClassLoader(oldCcl);
        }
    }

    @Override
    public void optionallyUpdateDelegatedUser(Directory directory, com.atlassian.crowd.model.user.User user) {
        try {
            DelegatedAuthenticationDirectory remote = (DelegatedAuthenticationDirectory)this.getDelegatedInstanceLoader().getDirectory(directory);
            boolean updateUser = Boolean.parseBoolean((String)directory.getAttributes().get("crowd.delegated.directory.auto.update.user"));
            boolean importGroups = Boolean.parseBoolean((String)directory.getAttributes().get("crowd.delegated.directory.importGroups"));
            if (updateUser || importGroups) {
                this.addOrUpdateLdapUser(user.getName(), remote);
            }
        }
        catch (UserNotFoundException e) {
            throw new IllegalStateException("User not found", e);
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String optionallyDecryptLdapPassword(String ldapPasswordParameter) {
        return ldapPasswordParameter;
    }

    protected Option<String> decryptLdapPassword(String encryptedLdapPassword, String encryptorClassName, String componentManagerClassName) {
        try {
            ClassLoader loader = this.getClass().getClassLoader().getParent();
            Class<?> componentManagerClass = loader.loadClass(componentManagerClassName);
            Method getInstanceMethod = componentManagerClass.getMethod("getInstance", new Class[0]);
            Object componentManager = getInstanceMethod.invoke(null, new Object[0]);
            Class[] params = new Class[]{Class.class};
            Method getComponentMethod = componentManagerClass.getDeclaredMethod("getComponent", params);
            params[0] = loader.loadClass(encryptorClassName);
            Object encryptor = getComponentMethod.invoke(componentManager, (Object[])params);
            params[0] = String.class;
            Method decryptMethod = loader.loadClass(encryptorClassName).getDeclaredMethod("decrypt", params);
            Object[] encryptedPasswordParam = new String[]{encryptedLdapPassword};
            String ldapPassword = (String)decryptMethod.invoke(encryptor, encryptedPasswordParam);
            if (CryptoUtils.secretIndicatesEncryptedValue(ldapPassword)) {
                log.warn("Could not decode LDAP/AD password from database. Check that username/password logins against your LDAP User Directory works. If not, you may have to recreate the LDAP User Directory.");
            }
            return Option.of(ldapPassword);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Could not load method in LDAP password fetch: ", (Throwable)e);
        }
        catch (Exception e) {
            log.warn("Failed to fetch LDAP password: ", (Throwable)e);
        }
        return Option.none();
    }

    @Override
    public RemoteDirectory getAuthorativeDirectory(DbCachingRemoteDirectory directoryInstance) {
        return directoryInstance.getAuthoritativeDirectory();
    }

    @Override
    public void optionallyAddCrowdGroups(com.atlassian.crowd.model.user.User user) {
        HashSet<String> addGroups = new HashSet<String>();
        String crowdAutoAddGroups = this.kerbConfManager.getCrowdAutoAddGroups();
        if (crowdAutoAddGroups != null) {
            for (String g : crowdAutoAddGroups.split(",")) {
                if ((g = g.trim()).isEmpty()) continue;
                addGroups.add(g);
            }
        }
        for (String addGroup : addGroups) {
            Group group = this.getCrowdService().getGroup(addGroup);
            if (group == null) continue;
            try {
                this.getCrowdService().addUserToGroup((User)user, group);
            }
            catch (OperationNotPermittedException | com.atlassian.crowd.exception.runtime.OperationFailedException throwable) {}
        }
    }

    @Override
    public boolean setDefaultGroups(Principal principal, Directory directory) {
        String autoAddGroupsDefinedInLdap = (String)directory.getAttributes().get("autoAddGroups");
        if (StringUtils.isNotBlank((String)autoAddGroupsDefinedInLdap)) {
            HashSet<String> groupItems = new HashSet<String>(Arrays.asList(autoAddGroupsDefinedInLdap.split("\\|")));
            for (String group : groupItems) {
                group = StringUtils.isNotBlank((String)group.trim()) ? group.trim() : group;
                try {
                    if (this.isUserInGroup(principal.getName(), group)) continue;
                    this.addUserToGroup(principal, group);
                }
                catch (Exception e) {
                    log.warn("Trying to add default ldap groups at login. Could not assign {} to {}. Error: {}", new Object[]{principal.getName(), group, e.getMessage()});
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public java.util.List<String> getPreemptivePathMappings() {
        return this.preemptivePathMappings;
    }

    <T> T findComponent(Class<T> type) {
        Collection component = ComponentLocator.getComponents(type);
        return component.isEmpty() ? null : (T)component.iterator().next();
    }

    @Override
    public boolean isRequestMapped(HttpServletRequest req, String r) {
        return false;
    }

    @Override
    public boolean isRESTRequestMapped(HttpServletRequest req, String r) {
        if (!this.isRestApi(r) || !this.kerbConfManager.isRestAuthEnabled() || this.isBasicAuth(req) || this.isOAuth(req) || this.isRestApiExcluded(r)) {
            return false;
        }
        if (req.getAttribute("javax.servlet.forward.request_uri") != null) {
            return false;
        }
        String remoteAddress = this.kerbConfManager.getRemoteIpAddress(req);
        IpRestrictionConfig restrictionCfg = this.kerbConfManager.getIpRestrictionConfig();
        IpRestrictionFilter restFilter = restrictionCfg.restIpFilter();
        return restFilter.isRemoteAddressEnabled(remoteAddress);
    }

    private boolean isOAuth(HttpServletRequest req) {
        String azn = req.getHeader("Authorization");
        if (azn != null) {
            return (azn = azn.toLowerCase()).startsWith("oauth") || azn.startsWith("bearer");
        }
        return false;
    }

    private boolean isBasicAuth(HttpServletRequest req) {
        String authorization = req.getHeader("Authorization");
        return authorization != null && authorization.startsWith("Basic ");
    }

    @Override
    public boolean isPreemptiveRequestMapped(HttpServletRequest req) {
        String internalPath = HttpUrlUtils.getInternalPath(req);
        Set<String> forcedSsoUrls = this.kerbConfManager.getForcedSsoUrls();
        for (String url : forcedSsoUrls) {
            boolean matching;
            if (org.apache.commons.lang3.StringUtils.endsWith(url, "*")) {
                url = org.apache.commons.lang3.StringUtils.substringBeforeLast(url, "*");
                matching = org.apache.commons.lang3.StringUtils.startsWith(internalPath, url);
            } else {
                matching = org.apache.commons.lang3.StringUtils.equals(internalPath, url);
            }
            if (!matching) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLoginRequest(HttpServletRequest req) {
        return false;
    }

    @Override
    public boolean isAuthTokenRequest(HttpServletRequest req) {
        return this.isOAuth(req) || this.isBasicAuth(req);
    }

    @Override
    public boolean isPasswordLoginRequest(HttpServletRequest req) {
        return org.apache.commons.lang3.StringUtils.isNotBlank(req.getParameter("os_password"));
    }

    @Override
    public String getLoginRequestUsername(HttpServletRequest req) {
        return null;
    }

    @Override
    public boolean hasRestApi() {
        return this.hasRestApi;
    }

    @Override
    public boolean isRestApi(String internalPath) {
        return Option.of(internalPath).map(path -> path.startsWith("/rest/")).getOrElse(false);
    }

    @Override
    public boolean shouldTryApiTokenAuthentication(HttpServletRequest req) {
        String internalPath = HttpUrlUtils.getInternalPath(req);
        boolean inAccessUrls = false;
        Set<String> tokenAccessUrls = this.kerbConfManager.getApiTokenAccessUrls();
        for (String url : tokenAccessUrls) {
            if (!org.apache.commons.lang3.StringUtils.startsWith(internalPath, url)) continue;
            inAccessUrls = true;
            break;
        }
        return this.kerbConfManager.isApiTokensEnabled() && (this.isRestApi(internalPath) || inAccessUrls || this.urlInAdditionalBuiltInApiRequest(req)) && HttpUrlUtils.requestHasBasicAuth(req);
    }

    @Override
    public boolean urlInAdditionalBuiltInApiRequest(HttpServletRequest req) {
        return false;
    }

    @Override
    public boolean shouldRequireCanLogin(HttpServletRequest req) {
        return true;
    }

    @Override
    public boolean isLoggedIn(HttpServletRequest req) {
        return Try.of(() -> req.getSession(false)).filterTry(Objects::nonNull).mapTry(this::isAppLoggedIn).getOrElse(false);
    }

    @Override
    public boolean isRequestFromHostApp(HttpServletRequest request) {
        boolean secFetchSiteHeaderMatches = Option.of(request.getHeader("Sec-Fetch-Site")).map(header -> List.of("same-origin", "same-site", "none").contains((String)header)).getOrElse(false);
        String baseUrlHost = Try.of(() -> new URI(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE)).getHost()).getOrElse("");
        boolean originHeaderMatches = Try.of(() -> request.getHeader("Origin")).mapTry(header -> baseUrlHost.equals(new URI((String)header).getHost())).getOrElse(false);
        boolean refererHeaderMatches = Try.of(() -> request.getHeader("Referer")).mapTry(header -> baseUrlHost.equals(new URI((String)header).getHost())).getOrElse(false);
        return this.isLoggedIn(request) || originHeaderMatches || refererHeaderMatches || secFetchSiteHeaderMatches;
    }

    @Override
    public boolean isRestPathInternalAtlassianFunctionality(HttpServletRequest request) {
        return Option.of(request).map(HttpUrlUtils::getInternalPath).map(internalPath -> internalPath.startsWith("/rest/applinks")).getOrElse(false);
    }

    protected boolean isAppLoggedIn(HttpSession session) {
        return session.getAttribute("seraph_defaultauthenticator_user") != null;
    }

    @Override
    public void invalidateSession(HttpServletResponse res, HttpServletRequest req) {
        Option.of(req.getSession(false)).peek(HttpSession::invalidate);
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequest req, HttpServletResponse res) {
        return false;
    }

    protected final void metaRefresh(HttpServletResponse resp, String url) throws IOException {
        resp.setContentType("text/html");
        resp.getWriter().print("<html><head><meta http-equiv=\"refresh\" content=\"0;URL='" + url + "'\" /></head></html>");
    }

    protected boolean checkTempCookie(HttpServletRequest req, HttpServletResponse res, String cookieName) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                Cookie delCookie = new Cookie(cookieName, "");
                delCookie.setMaxAge(0);
                delCookie.setPath(req.getContextPath() + "/");
                delCookie.setComment("HttpOnly");
                res.addCookie(delCookie);
                return true;
            }
        }
        return false;
    }

    @Override
    public void postSuccessfulLoginWithKerberosAction(Principal user, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.preventCaching(res);
        String os_destination = req.getParameter("os_destination");
        if (os_destination != null) {
            if (os_destination.startsWith("http")) {
                this.safeRedirect.sendRedirect(os_destination, req, res);
            } else {
                if (!os_destination.startsWith("/")) {
                    os_destination = "/" + os_destination;
                }
                this.safeRedirect.sendRedirect(req.getContextPath() + os_destination, req, res);
            }
        } else {
            String url = req.getRequestURI();
            String queryString = req.getQueryString();
            if (queryString != null) {
                url = url + "?" + queryString;
            }
            this.safeRedirect.sendRedirect(url, req, res);
        }
    }

    protected void preventCaching(HttpServletResponse res) {
        res.setHeader("Cache-Control", "private, max-age=0, no-cache");
    }

    @Override
    public CrowdDirectoryService getCrowdDirectoryService() {
        return this.crowdDirectoryService;
    }

    @Override
    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    @Override
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Override
    public ApplicationService getApplicationService() {
        return this.applicationService;
    }

    @Override
    public DelegatedAuthenticationDirectoryInstanceLoader getDelegatedInstanceLoader() {
        return this.delegatedInstanceLoader;
    }

    @Override
    public MultipartHttpRequest getMultipartRequest(HttpServletRequest req, long maxSize) throws IOException {
        if (ServletFileUpload.isMultipartContent(req)) {
            ServletFileUpload upload = new ServletFileUpload(new DiskFileItemFactory());
            upload.setFileSizeMax(maxSize);
            try {
                final java.util.List<FileItem> list = upload.parseRequest(new ServletRequestContext(req));
                return new MultipartHttpRequest(req){

                    public String getParameter(String name) {
                        for (FileItem fileItem : list) {
                            if (!fileItem.isFormField() || !name.equals(fileItem.getFieldName())) continue;
                            return fileItem.getString();
                        }
                        return null;
                    }

                    public Map<String, String[]> getParameterMap() {
                        HashMap params = new HashMap();
                        for (FileItem fileItem : list) {
                            if (!fileItem.isFormField()) continue;
                            if (!params.containsKey(fileItem.getFieldName())) {
                                params.put(fileItem.getFieldName(), new ArrayList());
                            }
                            ((java.util.List)params.get(fileItem.getFieldName())).add(fileItem.getString());
                        }
                        HashMap<String, String[]> result = new HashMap<String, String[]>();
                        for (String name : params.keySet()) {
                            java.util.List values2 = (java.util.List)params.get(name);
                            result.put(name, values2.toArray(new String[values2.size()]));
                        }
                        return result;
                    }

                    @Override
                    public byte[] getFile(String name) {
                        for (FileItem fileItem : list) {
                            if (fileItem.isFormField() || !name.equals(fileItem.getFieldName())) continue;
                            return fileItem.get();
                        }
                        return null;
                    }

                    @Override
                    public String getFilename(String name) {
                        for (FileItem fileItem : list) {
                            if (fileItem.isFormField() || !name.equals(fileItem.getFieldName())) continue;
                            return fileItem.getName();
                        }
                        return null;
                    }
                };
            }
            catch (FileUploadException e) {
                throw new IOException(e);
            }
        }
        return new MultipartHttpRequest(req){

            @Override
            public byte[] getFile(String name) {
                throw new IllegalStateException("Not a multipart request");
            }

            @Override
            public String getFilename(String name) {
                throw new IllegalStateException("Not a multipart request");
            }
        };
    }

    @Override
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Override
    public boolean isPublicAccessEnabled() {
        return false;
    }

    @Override
    public boolean isUserInGroup(String username, String group) {
        return this.getCrowdService().isUserMemberOfGroup(username, group);
    }

    @Override
    public boolean isUserInRequiredGroups(String username) {
        Set<String> requiredGroups = this.kerbConfManager.getRequiredGroups();
        if (requiredGroups.isEmpty()) {
            return true;
        }
        return requiredGroups.stream().anyMatch(group -> this.isUserInGroup(username, (String)group));
    }

    @Override
    public boolean isExistingGroup(String groupName) {
        return this.getCrowdService().getGroup(groupName) != null;
    }

    @Override
    public void addGroup(final String groupName) {
        try {
            this.getCrowdService().addGroup(new Group(){

                public String getName() {
                    return groupName;
                }

                public int compareTo(Group group) {
                    return groupName.compareTo(group.getName());
                }
            });
        }
        catch (InvalidGroupException e) {
            log.error("Unable to create group: " + groupName, (Throwable)e);
        }
        catch (OperationNotPermittedException e) {
            log.error("Not enough rights to create group: " + groupName, (Throwable)e);
        }
    }

    @Override
    public void addAuthenticatedAnonymousBrowsingSession(String username, IdpConfiguration idpConfiguration, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Option.of(request.getSession(true)).peek(authenticatedAnonymousBrowsingSession -> {
            authenticatedAnonymousBrowsingSession.setAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_SESSION_IDP_ID", (Object)idpConfiguration.getId());
            authenticatedAnonymousBrowsingSession.setAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_USER", (Object)Option.of(username).getOrElse("[anonymous]"));
        });
        response.sendRedirect(request.getContextPath() + "/");
    }

    @Override
    public boolean removeNonIdpGroupsFromUser(Principal principal, Set<String> groupsFromIdp) {
        boolean failing = false;
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(principal.getName()).startingAt(0).returningAtMost(-1);
        for (Directory directory : this.getCrowdDirectoryService().findAllDirectories()) {
            if (!this.isWritableAndActive(directory) || directory.getType() != DirectoryType.INTERNAL) continue;
            try {
                java.util.List userCurrentGroups = this.getDirectoryManager().searchNestedGroupRelationships(directory.getId().longValue(), membershipQuery);
                for (String userGroup : userCurrentGroups) {
                    if (groupsFromIdp.contains(userGroup)) continue;
                    this.removeUserFromGroup(principal, userGroup);
                }
            }
            catch (DirectoryNotFoundException e) {
                log.error("Directory not found during group search", (Throwable)e);
                failing = true;
            }
            catch (OperationFailedException e) {
                log.error("Operation failed during group search", (Throwable)e);
                failing = true;
            }
        }
        return failing;
    }

    @Override
    public boolean addUserToGroup(Principal principal, String groupName) {
        try {
            User user = this.crowdService.getUser(principal.getName());
            Group group = this.crowdService.getGroup(groupName);
            if (user != null && group != null) {
                this.getCrowdService().addUserToGroup(user, group);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error(String.format("Failed adding user '%s' to group '%s'", principal.getName(), groupName), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean removeUserFromGroup(Principal principal, String groupName) {
        try {
            User user = this.crowdService.getUser(principal.getName());
            Group group = this.crowdService.getGroup(groupName);
            if (user != null && group != null) {
                this.getCrowdService().removeUserFromGroup(user, group);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error(String.format("Failed removing user '%s' to group '%s'", principal.getName(), groupName), (Throwable)e);
            return false;
        }
    }

    @Override
    public String hasNonStandardAuthenticator() {
        String standardAuthenticatorClass = this.getStandardAuthenticatorClassName();
        if (standardAuthenticatorClass == null) {
            return null;
        }
        Authenticator authenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        if (!authenticator.getClass().getName().equals(standardAuthenticatorClass)) {
            return authenticator.getClass().getName();
        }
        return null;
    }

    @Override
    public String getStandardAuthenticatorClassName() {
        return null;
    }

    @Override
    public void publishUserAuthenticatedEvent(Principal user) {
        User crowdServiceUser = this.getCrowdService().getUser(user.getName());
        Directory directory = this.getCrowdDirectoryService().findDirectoryById(crowdServiceUser.getDirectoryId());
        Application application = ((ApplicationFactory)ComponentLocator.getComponent(ApplicationFactory.class)).getApplication();
        DirectoryManager manager = (DirectoryManager)ComponentLocator.getComponent(DirectoryManager.class);
        try {
            com.atlassian.crowd.model.user.User userByName = manager.findUserByName(directory.getId().longValue(), user.getName());
            this.eventPublisher.publish((Object)new UserAuthenticatedEvent((Object)this, directory, application, userByName));
        }
        catch (DirectoryNotFoundException e) {
            log.error("Directory not found", (Throwable)e);
        }
        catch (UserNotFoundException e) {
            log.error("User not found", (Throwable)e);
        }
        catch (OperationFailedException e) {
            log.error("Operation failed", (Throwable)e);
        }
    }

    @Override
    public Optional<Directory> findJitDirectory(Optional<Long> directoryId) {
        if (!directoryId.isPresent()) {
            return this.getDefaultJitDirectory();
        }
        for (Directory directory : this.getCrowdDirectoryService().findAllDirectories()) {
            if (!directory.getId().equals(directoryId.get())) continue;
            return Optional.of(directory);
        }
        return Optional.empty();
    }

    protected void seraphLikeInvalidateSession(HttpServletRequest httpServletRequest) {
        HttpSession session = httpServletRequest.getSession(false);
        SecurityConfig securityConfig = SecurityConfigFactory.getInstance();
        if (!securityConfig.isInvalidateSessionOnLogin()) {
            return;
        }
        java.util.List excludeList = securityConfig.getInvalidateSessionExcludeList();
        if (session != null && !session.isNew()) {
            HashMap<String, Object> sessionContents = new HashMap<String, Object>();
            Enumeration attributes = session.getAttributeNames();
            while (attributes.hasMoreElements()) {
                String name = (String)attributes.nextElement();
                if (excludeList.contains(name)) continue;
                sessionContents.put(name, session.getAttribute(name));
            }
            try {
                session.invalidate();
                HttpSession newSession = httpServletRequest.getSession(true);
                for (Map.Entry entry : sessionContents.entrySet()) {
                    newSession.setAttribute((String)entry.getKey(), entry.getValue());
                }
            }
            catch (IllegalStateException e) {
                log.warn("Couldn't invalidate for request because " + e.getMessage());
            }
        }
    }

    @Override
    public boolean shouldDisableHardRedirect(HttpServletRequest req) {
        String samlRedirectTarget = this.getRedirectTarget(req);
        return req.getParameter("noautosso") != null || samlRedirectTarget != null && samlRedirectTarget.contains("noautosso");
    }

    @Override
    public boolean canLogin(Principal user, HttpServletRequest request) {
        return this.authenticationController.canLogin(user, request);
    }

    @Override
    public boolean supportsRemoveAllRememberMeTokens() {
        return false;
    }

    @Override
    public void removeAllRememberMeTokens() {
        throw new RuntimeException("Not implemented for " + this.applicationProperties.getDisplayName() + ", check supportsRemoveAllRememberMeTokens before calling this method!");
    }

    @Override
    public void setRememberMeCookie(HttpServletRequest request, HttpServletResponse response, String username) {
        log.debug("Remember me functionality is not implemented for this product");
    }

    @Override
    public boolean canAddUser() {
        for (Directory directory : this.getCrowdDirectoryService().findAllDirectories()) {
            if (!this.isWritableAndActive(directory)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWritableAndActive(Directory directory) {
        return directory.isActive() && (directory.getType() == DirectoryType.INTERNAL || directory.getType() == DirectoryType.DELEGATING || directory.getType() == DirectoryType.CROWD) && directory.getAllowedOperations().contains(OperationType.CREATE_USER);
    }

    @Override
    public Set<Directory> getWritableUserDirectories() {
        HashSet<Directory> directories = new HashSet<Directory>();
        for (Directory directory : this.getCrowdDirectoryService().findAllDirectories()) {
            if (!this.isWritableAndActive(directory)) continue;
            directories.add(directory);
        }
        return directories;
    }

    @Override
    public Optional<Directory> getDefaultJitDirectory() {
        HashSet<Directory> directories = new HashSet<Directory>();
        for (Directory directory : this.getCrowdDirectoryService().findAllDirectories()) {
            if (!this.isWritableAndActive(directory) || directory.getType() != DirectoryType.INTERNAL) continue;
            directories.add(directory);
        }
        if (directories.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(directories.iterator().next());
    }

    @Override
    public Directory getDirectoryForUser(String username) {
        User user = this.getCrowdService().getUser(username);
        if (user != null) {
            return this.getCrowdDirectoryService().findDirectoryById(user.getDirectoryId());
        }
        return null;
    }

    @Override
    public void addUser(Directory directory, String username, String fullName, String email, Set<String> groups2) {
        try {
            UserTemplateWithAttributes template = new UserTemplateWithAttributes(username, directory.getId().longValue());
            template.setDisplayName(fullName);
            template.setEmailAddress(email);
            template.setActive(true);
            template.setAttribute(KSSO_SAML_JIT, "true");
            UserWithAttributes u = this.getDirectoryManager().addUser(directory.getId().longValue(), template, PasswordCredential.NONE);
            for (String groupName : groups2) {
                Group group = this.getCrowdService().getGroup(groupName);
                if (group == null) continue;
                this.getCrowdService().addUserToGroup((User)u, group);
            }
        }
        catch (UserAlreadyExistsException e) {
            log.warn("Was unable to create user " + username + " with just-in-time provisioning because the user already exist locally. Make sure your user directires are synchronized. ");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateUser(Directory directory, String username, String fullName, String email, boolean isActive) {
        try {
            UserTemplateWithAttributes template = new UserTemplateWithAttributes(username, directory.getId().longValue());
            template.setDisplayName(fullName);
            template.setEmailAddress(email);
            template.setActive(isActive);
            this.crowdService.updateUser((User)template);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String normalizeUsername(String username) {
        return username;
    }

    @Override
    public boolean isSMTPSupported() {
        return true;
    }

    @Override
    public boolean isSMTPEnabled() {
        MailServerManager serverManager = MailFactory.getServerManager();
        return serverManager.isDefaultSMTPMailServerDefined();
    }

    @Override
    public void sendEmail(String recipient, String subject, String body) {
        Email email = new Email(recipient);
        email.setSubject(subject);
        email.setBody(body);
        try {
            MailFactory.getServerManager().getDefaultSMTPMailServer().send(email);
        }
        catch (MailException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRedirectTarget(HttpServletRequest req) {
        String osDestination = req.getParameter("os_destination");
        if (osDestination != null) {
            if (this.safeRedirect.isLocal(osDestination)) {
                if (!osDestination.startsWith("/")) {
                    osDestination = "/" + osDestination;
                }
                return req.getContextPath() + osDestination;
            }
            return osDestination;
        }
        return null;
    }

    @Override
    public File getHomeDirectory() {
        return new File(this.applicationProperties.getHomeDirectory(), "kerberos");
    }

    @Override
    public boolean isRestApiExcluded(String r) {
        String basePath = "/rest";
        if (r.startsWith(basePath)) {
            for (String path : this.kerbConfManager.getRestExcludedPaths()) {
                if (!r.startsWith(basePath + path)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isForwarded(HttpServletRequest req) {
        return req.getAttribute("javax.servlet.forward.request_uri") != null;
    }

    boolean shouldDispatchToLoginPage() {
        return !this.kerbConfManager.isKeytabConfigured() || this.kerbConfManager.isPreemptiveAuthEnabled() && this.kerbConfManager.isSendToLoginEnabled();
    }

    @Override
    public boolean shouldCheckUserAccess() {
        return false;
    }

    @Override
    public boolean isSyncDirCompatible() {
        return true;
    }

    private boolean isHasRestApi() {
        return this.hasRestApi;
    }

    @Override
    public JSONObject asJson() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        JSONObject json = new JSONObject();
        JSONObject restAPIObj = new JSONObject();
        restAPIObj.put("has.rest.api", this.isHasRestApi());
        json.put("rest.api", restAPIObj);
        JSONObject environmentObj = new JSONObject();
        JSONObject javaObj = new JSONObject();
        javaObj.put("jvm.time.zone", TimeZone.getDefault().getDisplayName());
        javaObj.put("version", System.getProperty("java.version"));
        javaObj.put("class.path", System.getProperty("java.class.path"));
        javaObj.put("home", System.getProperty("java.home"));
        javaObj.put("vendor", System.getProperty("java.vendor"));
        environmentObj.put("java", javaObj);
        JSONObject osObj = new JSONObject();
        osObj.put("arch", System.getProperty("os.arch"));
        osObj.put("name", System.getProperty("os.name"));
        osObj.put("version", System.getProperty("os.version"));
        environmentObj.put("os", osObj);
        json.put("environment", environmentObj);
        JSONObject appPropsObj = new JSONObject();
        appPropsObj.put("display.name", this.applicationProperties.getDisplayName());
        appPropsObj.put("version", this.applicationProperties.getVersion());
        appPropsObj.put("base.url", this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        appPropsObj.put("platform.id", this.applicationProperties.getPlatformId());
        JSONObject buildObj = new JSONObject();
        buildObj.put("date", dateFormat.format(this.applicationProperties.getBuildDate()));
        buildObj.put("number", this.applicationProperties.getBuildNumber());
        appPropsObj.put("build", buildObj);
        appPropsObj.put("home.directory.path", Option.of(this.applicationProperties.getHomeDirectory()).map(File::getAbsolutePath).getOrElse(""));
        json.put("application.properties", appPropsObj);
        JSONObject crowdServiceObj = new JSONObject();
        crowdServiceObj.put("can.new.user.reset.password", this.crowdService.getCapabilitiesForNewUsers().canResetPassword());
        json.put("crowd.service", crowdServiceObj);
        return json;
    }

    @Override
    public boolean isScimRequest(HttpServletRequest req) {
        String internalPath = HttpUrlUtils.getInternalPath(req);
        return Option.of(internalPath).map(path -> path.startsWith("/scim/") || path.startsWith("/plugins/servlet/ksso/scim/")).getOrElse(false);
    }

    @Override
    public boolean isJiraCrowdRequest(HttpServletRequest req) {
        return false;
    }
}

