/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.hostapp;

import com.atlassian.crowd.directory.DelegatedAuthenticationDirectory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.UserManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.json.JSONObject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.SafeRedirect;
import org.kantega.atlaskerb.hostapp.DefaultHostApp;
import org.kantega.atlaskerb.hostapp.StatusPreservingResponse;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

class BambooHostApp
extends DefaultHostApp {
    private static final String HTTP_REQUEST_IS_MUTATIVE_KEY = "bamboo.http.request.isMutative";
    private final UserManager userManager;
    private final BambooFileExtractor fileExtractor;
    private final Method getRequestCache;

    public BambooHostApp(TransactionTemplate transactionTemplate, ApplicationProperties applicationProperties, AuthenticationListener authenticationListener, EventPublisher eventPublisher, AuthenticationController authenticationController, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, SafeRedirect safeRedirect, KerbConfManager kerbConfManager) {
        super(transactionTemplate, applicationProperties, authenticationListener, eventPublisher, authenticationController, crowdDirectoryService, crowdService, safeRedirect, kerbConfManager);
        this.preemptivePathMappings.add("/");
        this.preemptivePathMappings.add("/browse/*");
        this.preemptivePathMappings.add("/allPlans.action");
        this.preemptivePathMappings.add("/currentActivity.action");
        this.preemptivePathMappings.add("/myBamboo.action");
        this.preemptivePathMappings.add("/reports/*");
        this.preemptivePathMappings.add("/authors/*");
        this.preemptivePathMappings.add("/deploy/viewAllDeploymentProjects.action");
        this.hasRestApi = true;
        this.userManager = (UserManager)ComponentLocator.getComponent(UserManager.class);
        this.fileExtractor = applicationProperties.getVersion().startsWith("5.") ? new Bamboo5FileExtractor() : new Bamboo6FileExtractor();
        try {
            Class<?> clz = this.getClass().getClassLoader().getParent().loadClass("com.atlassian.bamboo.util.RequestCacheThreadLocal");
            this.getRequestCache = clz.getMethod("getRequestCache", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Cannot RequestCacheThreadLocal", e);
        }
    }

    @Override
    public boolean isProductMatch(String product) {
        return "bamboo".equals(product);
    }

    @Override
    public boolean isRequestMapped(HttpServletRequest req, String r) {
        return r.startsWith("/userlogin!");
    }

    @Override
    public boolean isPreemptiveRequestMapped(HttpServletRequest req) {
        String r = req.getRequestURI().substring(req.getContextPath().length());
        int jsessionIdx = r.indexOf(";jsessionid");
        if (jsessionIdx != -1) {
            r = r.substring(0, jsessionIdx);
        }
        if (super.isPreemptiveRequestMapped(req) || r.equals("/") || r.equals("/allPlans.action") || r.equals("/currentActivity.action") || r.equals("/myBamboo.action") || r.startsWith("/reports/") || r.startsWith("/authors/") || r.startsWith("/deploy/viewAllDeploymentProjects.action")) {
            return true;
        }
        String forwardededRequestUri = (String)req.getAttribute("javax.servlet.forward.request_uri");
        if (forwardededRequestUri != null) {
            forwardededRequestUri = forwardededRequestUri.substring(req.getContextPath().length());
            return forwardededRequestUri.startsWith("/browse/");
        }
        return false;
    }

    @Override
    public boolean isPageWithLoginForm(HttpServletRequest req, String requestUrl) {
        return this.isMainLoginPage(requestUrl);
    }

    @Override
    public boolean isMainLoginPage(String requestUrl) {
        return requestUrl.startsWith(this.getLoginPage());
    }

    @Override
    public void dispatchToLogin(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String requestPath = req.getRequestURI().substring(req.getContextPath().length());
        String queryString = req.getQueryString();
        if (this.isPreemptiveRequestMapped(req) && this.shouldDispatchToLoginPage()) {
            resp.sendRedirect(req.getContextPath() + "/userlogin!doDefault.action?trykerberos&os_destination=" + HttpUrlUtils.urlEncode(requestPath) + "%3F" + HttpUrlUtils.urlEncode(req.getQueryString()));
        } else if (!this.isPageWithLoginForm(req, requestPath) && !this.shouldDispatchToLoginPage()) {
            chain.doFilter((ServletRequest)req, (ServletResponse)new StatusPreservingResponse(resp));
        } else if (requestPath.startsWith(this.getLoginPage()) && (StringUtils.contains((CharSequence)queryString, "nokerberos") || StringUtils.contains((CharSequence)queryString, "trykerberos"))) {
            chain.doFilter((ServletRequest)req, (ServletResponse)new StatusPreservingResponse(resp));
        } else {
            String targetUrl;
            String nokerberos = "nokerberos&";
            if (req.getQueryString() != null && req.getQueryString().contains("trykerberos")) {
                nokerberos = "";
            }
            if (StringUtils.isBlank(targetUrl = HttpUrlUtils.urlEncode(req.getHeader("referer")))) {
                targetUrl = HttpUrlUtils.urlEncode(requestPath) + "%3F" + HttpUrlUtils.urlEncode(req.getQueryString());
            }
            if (targetUrl.contains("logout%3FSAMLResponse")) {
                targetUrl = "";
            }
            this.metaRefresh(resp, req.getContextPath() + "/userlogin!doDefault.action?" + nokerberos + "os_destination=" + targetUrl);
        }
    }

    @Override
    public Principal authenticateWithProduct(HttpServletRequest req, HttpServletResponse res, Principal user) {
        this.invalidateSession(req);
        this.authenticationListener.authenticationSuccess((Authenticator.Result)new Authenticator.Result.Success(user), req, res);
        req.getSession().setAttribute("seraph_defaultauthenticator_user", (Object)user);
        return user;
    }

    @Override
    public void publishUserAuthenticatedEvent(Principal user) {
        this.runTxUnchecked(() -> super.publishUserAuthenticatedEvent(user));
    }

    @Override
    public void optionallyUpdateUserFromRemoteDirectory(String username, Directory directory, boolean isNewlyCreatedUser) throws OperationFailedException, UserNotFoundException, InactiveAccountException {
        this.runTx2(() -> super.optionallyUpdateUserFromRemoteDirectory(username, directory, isNewlyCreatedUser));
    }

    @Override
    public boolean createDelegatedUser(Directory directory, String username) {
        return (Boolean)this.runTxUnchecked(() -> super.createDelegatedUser(directory, username));
    }

    @Override
    public void addOrUpdateLdapUser(String username, DelegatedAuthenticationDirectory remote) throws UserNotFoundException, OperationFailedException {
        this.runTx(() -> super.addOrUpdateLdapUser(username, remote));
    }

    @Override
    public void optionallyUpdateDelegatedUser(Directory directory, User user) {
        this.runTxUnchecked(() -> super.optionallyUpdateDelegatedUser(directory, user));
    }

    @Override
    public void optionallyAddCrowdGroups(User user) {
        this.runTxUnchecked(() -> super.optionallyAddCrowdGroups(user));
    }

    @Override
    public boolean setDefaultGroups(Principal principal, Directory directory) {
        return (Boolean)this.runTxUnchecked(() -> super.setDefaultGroups(principal, directory));
    }

    @Override
    public boolean addUserToGroup(Principal principal, String groupName) {
        return (Boolean)this.runTxUnchecked(() -> super.addUserToGroup(principal, groupName));
    }

    @Override
    public boolean removeUserFromGroup(Principal principal, String groupName) {
        return (Boolean)this.runTxUnchecked(() -> super.removeUserFromGroup(principal, groupName));
    }

    @Override
    public void addUser(Directory directory, String username, String fullName, String email, Set<String> groups2) {
        this.runTxUnchecked(() -> super.addUser(directory, username, fullName, email, groups2));
    }

    @Override
    public void updateUser(Directory directory, String username, String fullName, String email, boolean isActive) {
        this.runTxUnchecked(() -> super.updateUser(directory, username, fullName, email, isActive));
    }

    private Map<String, Object> getRequestCache() {
        try {
            return (Map)ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)ComponentLocator.class.getClassLoader(), () -> (Map)this.getRequestCache.invoke(null, new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void invalidateSession(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.invalidate();
            req.getSession(true);
        }
    }

    @Override
    public boolean isLoginRequest(HttpServletRequest req) {
        return "POST".equals(req.getMethod()) && req.getRequestURI().startsWith(req.getContextPath() + "/userlogin.action");
    }

    @Override
    public String getLoginRequestUsername(HttpServletRequest req) {
        return req.getParameter("os_username");
    }

    @Override
    protected boolean isAppLoggedIn(HttpSession session) {
        return session.getAttribute("seraph_defaultauthenticator_user") != null;
    }

    @Override
    public boolean shouldLoginManually(HttpServletRequest req, HttpServletResponse res) {
        return this.checkTempCookie(req, res, "krb_bamboo_logout");
    }

    @Override
    public void postSuccessfulLoginWithKerberosAction(Principal user, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException {
        String url;
        this.preventCaching(res);
        if (this.isPreemptiveRequestMapped(req) && (url = this.getPossiblyForwardedRedirectURL(req)) != null) {
            res.sendRedirect(url);
            return;
        }
        String origUrl = req.getParameter("os_destination");
        if (origUrl != null) {
            this.safeRedirect.sendRedirect(req.getContextPath() + origUrl, req, res);
        } else {
            res.sendRedirect(req.getContextPath() + "/");
        }
    }

    private String getPossiblyForwardedRedirectURL(HttpServletRequest req) {
        String url = (String)req.getAttribute("javax.servlet.forward.request_uri");
        String queryString = null;
        if (url == null) {
            url = req.getRequestURI();
            queryString = req.getQueryString();
        }
        if (url != null) {
            if (queryString != null) {
                url = url + "?" + queryString;
            }
            return url;
        }
        return null;
    }

    @Override
    public MultipartHttpRequest getMultipartRequest(final HttpServletRequest req, long maxSize) throws IOException {
        final MultiPartRequestWrapper wrapper = this.unwrap(req, MultiPartRequestWrapper.class);
        return new MultipartHttpRequest((HttpServletRequest)wrapper){

            public String getParameter(String name) {
                if (wrapper != null) {
                    return wrapper.getParameter(name);
                }
                return req.getParameter(name);
            }

            @Override
            public byte[] getFile(String name) {
                if (wrapper != null) {
                    return BambooHostApp.this.fileExtractor.extractBytes(wrapper, name);
                }
                return null;
            }

            @Override
            public String getFilename(String name) {
                String[] fileNames = wrapper.getFileNames(name);
                return fileNames == null || fileNames.length == 0 ? null : fileNames[0];
            }
        };
    }

    public <T extends HttpServletRequestWrapper> T unwrap(HttpServletRequest request, Class<T> clazz) {
        while (request != null) {
            if (clazz.isAssignableFrom(request.getClass())) {
                return (T)((HttpServletRequestWrapper)clazz.cast(request));
            }
            request = request instanceof HttpServletRequestWrapper ? (HttpServletRequest)((HttpServletRequestWrapper)request).getRequest() : null;
        }
        return null;
    }

    @Override
    public String getStandardAuthenticatorClassName() {
        return "com.atlassian.bamboo.user.authentication.BambooAuthenticator";
    }

    @Override
    public String getUserManagerLink() {
        return "/admin/user/viewUsers.action";
    }

    @Override
    public boolean canAddUser() {
        return this.userManager.isCreative();
    }

    @Override
    public String normalizeUsername(String username) {
        return username.toLowerCase();
    }

    @Override
    public String getLoginPage() {
        return "/userlogin!doDefault.action";
    }

    @Override
    public String getLogoutPage() {
        return "/start.action";
    }

    @Override
    public int getDefaultApiServerPort() {
        return 5504;
    }

    private void runTxUnchecked(Runnable runnable2) {
        TransactionCallback cb = () -> {
            runnable2.run();
            return null;
        };
        this.runTxUnchecked(cb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runTxUnchecked(TransactionCallback<T> callback) {
        Map<String, Object> cache = this.getRequestCache();
        Object prev = cache.put(HTTP_REQUEST_IS_MUTATIVE_KEY, true);
        try {
            Object object = this.transactionTemplate.execute(callback);
            return (T)object;
        }
        finally {
            if (prev != null) {
                cache.put(HTTP_REQUEST_IS_MUTATIVE_KEY, prev);
            }
        }
    }

    private void runTx(UserDirectoryRunnable runnable2) throws UserNotFoundException, OperationFailedException {
        UserDirectoryCallable<Void> callable = runnable2.asCallable();
        try {
            this.runTx(callable);
        }
        catch (InactiveAccountException e) {
            throw new RuntimeException("Unexpected checked exception", e);
        }
    }

    private void runTx2(UserDirectoryRunnable runnable2) throws UserNotFoundException, OperationFailedException, InactiveAccountException {
        UserDirectoryCallable<Void> callable = runnable2.asCallable();
        this.runTx(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runTx(UserDirectoryCallable<T> callable) throws UserNotFoundException, OperationFailedException, InactiveAccountException {
        Map<String, Object> cache = this.getRequestCache();
        Object prev = cache.put(HTTP_REQUEST_IS_MUTATIVE_KEY, true);
        try {
            TransactionCallback<T> cb = this.wrap(callable);
            Object object = this.transactionTemplate.execute(cb);
            return (T)object;
        }
        catch (WrappedCrowdException e) {
            T t = this.unwrap(e);
            return t;
        }
        finally {
            if (prev != null) {
                cache.put(HTTP_REQUEST_IS_MUTATIVE_KEY, prev);
            }
        }
    }

    private <T> T unwrap(WrappedCrowdException e) throws UserNotFoundException, OperationFailedException, InactiveAccountException {
        Throwable cause = e.getCause();
        if (cause instanceof UserNotFoundException) {
            throw (UserNotFoundException)cause;
        }
        if (cause instanceof OperationFailedException) {
            throw (OperationFailedException)cause;
        }
        if (cause instanceof InactiveAccountException) {
            throw (InactiveAccountException)cause;
        }
        throw e;
    }

    private <T> TransactionCallback<T> wrap(UserDirectoryCallable<T> callback) {
        return () -> {
            try {
                return callback.call();
            }
            catch (InactiveAccountException | OperationFailedException | UserNotFoundException e) {
                throw new WrappedCrowdException((CrowdException)e);
            }
        };
    }

    @Override
    public JSONObject asJson() {
        return super.asJson();
    }

    @FunctionalInterface
    static interface UserDirectoryCallable<T> {
        public T call() throws UserNotFoundException, OperationFailedException, InactiveAccountException;
    }

    @FunctionalInterface
    static interface UserDirectoryRunnable {
        public void run() throws UserNotFoundException, OperationFailedException, InactiveAccountException;

        default public UserDirectoryCallable<Void> asCallable() {
            return () -> {
                this.run();
                return null;
            };
        }
    }

    private static class WrappedCrowdException
    extends RuntimeException {
        public WrappedCrowdException(CrowdException e) {
            super((Throwable)e);
        }
    }

    static class Bamboo6FileExtractor
    extends BambooFileExtractor {
        Bamboo6FileExtractor() {
        }

        @Override
        public byte[] extractBytes(MultiPartRequestWrapper wrapper, String name) {
            UploadedFile[] files = wrapper.getFiles(name);
            if (files != null) {
                for (UploadedFile file : files) {
                    if (!file.isFile()) continue;
                    try {
                        return FileUtils.readFileToByteArray((File)((File)file.getContent()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return null;
        }
    }

    static class Bamboo5FileExtractor
    extends BambooFileExtractor {
        private final Method getFile;

        Bamboo5FileExtractor() {
            try {
                this.getFile = MultiPartRequestWrapper.class.getMethod("getFiles", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Bamboo5FileExtractor cannot be instanciated on Bamboo >=6", e);
            }
        }

        @Override
        public byte[] extractBytes(MultiPartRequestWrapper wrapper, String name) {
            File[] fileArray;
            int n;
            int n2;
            File[] files;
            try {
                files = (File[])this.getFile.invoke((Object)wrapper, name);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            if (files != null && (n2 = 0) < (n = (fileArray = files).length)) {
                File file = fileArray[n2];
                try {
                    return FileUtils.readFileToByteArray((File)file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }

    static abstract class BambooFileExtractor {
        BambooFileExtractor() {
        }

        public abstract byte[] extractBytes(MultiPartRequestWrapper var1, String var2);
    }
}

