/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.model.filters;

import java.util.Objects;
import java.util.Set;

public abstract class ConnectorFilter {
    SelectionMode mode;
    Set<String> includedGroups;
    Set<String> excludedGroups;

    public ConnectorFilter(SelectionMode mode, Set<String> includedGroups, Set<String> excludedGroups) {
        this.mode = Objects.requireNonNull(mode);
        this.includedGroups = Objects.requireNonNull(includedGroups);
        this.excludedGroups = Objects.requireNonNull(excludedGroups);
    }

    public SelectionMode getMode() {
        return this.mode;
    }

    public Set<String> getIncludedGroups() {
        return this.includedGroups;
    }

    public Set<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    public static enum SelectionMode {
        ALL,
        INCLUDE_SUBSET,
        EXCLUDE_SUBSET;


        public static SelectionMode ofString(String mode) {
            if ("INCLUDE_SUBSET_KEEP_MEMBERSHIPS".equals(mode)) {
                return INCLUDE_SUBSET;
            }
            return SelectionMode.valueOf(mode);
        }
    }
}

