/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.gsuite;

import com.atlassian.json.jsonorg.JSONObject;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.connector.ConnectorType;
import org.kantega.atlaskerb.connector.api.ConnectorAPI;
import org.kantega.atlaskerb.connector.api.ConnectorApiException;
import org.kantega.atlaskerb.connector.api.GroupHandler;
import org.kantega.atlaskerb.connector.gsuite.GSuiteApi;
import org.kantega.atlaskerb.connector.gsuite.GSuiteDirectory;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.connector.model.crowdapi.GroupItem;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GSuiteConnectorType
implements ConnectorType {
    private final ConnectorConfManager connectorConfManager;

    public GSuiteConnectorType(ConnectorConfManager connectorConfManager) {
        this.connectorConfManager = connectorConfManager;
    }

    @Override
    public ConnectorAPI getConnectorApi(Directory directory) {
        GSuiteDirectory gd = (GSuiteDirectory)directory;
        return new GSuiteApi(gd.getDomainName(), gd.getCustomerId().orElse(null), gd.getServiceAccountId(), gd.getAdminAccountAddress(), gd.getPrivateKey());
    }

    @Override
    public String getKey() {
        return "GSUITE";
    }

    @Override
    public String getDisplayName() {
        return "Google GSuite";
    }

    @Override
    public String getEditDirectoryTemplate() {
        return "gsuite/edit-connector.vm";
    }

    @Override
    public Directory processEditDirectoryPost(MultipartHttpRequest multipartRequest, Map<String, Object> model, Directory existingConnector, Directory.Common common) {
        String domainName = multipartRequest.getParameter("domainName").trim();
        String customerId = multipartRequest.getParameter("customerId").trim();
        String adminAccountAddress = multipartRequest.getParameter("adminAccountAddress").trim();
        model.put("domainName", domainName);
        model.put("customerId", customerId);
        model.put("adminAccountAddress", adminAccountAddress);
        String serviceAccountId = null;
        String privateKey = null;
        if (existingConnector != null) {
            GSuiteDirectory dir = (GSuiteDirectory)existingConnector;
            serviceAccountId = dir.getServiceAccountId();
            privateKey = dir.getPrivateKey();
        }
        byte[] jsonFile = multipartRequest.getFile("jsonFile");
        String serviceAccountEmail = multipartRequest.getParameter("serviceAccountEmail");
        String privateKeyParam = multipartRequest.getParameter("privateKey");
        if (jsonFile != null && jsonFile.length > 0) {
            String filename = multipartRequest.getFilename("jsonFile");
            if (filename != null && !filename.toLowerCase().endsWith(".json") || jsonFile[0] != 123) {
                model.put("notJson", true);
                return null;
            }
            JSONObject json = null;
            try {
                json = new JSONObject(new String(jsonFile, "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Utf8 not supported?", e);
            }
            catch (Exception e) {
                model.put("jsonParseException", e);
                return null;
            }
            if (json.isNull("private_key") || json.isNull("client_email")) {
                model.put("invalidJson", true);
                return null;
            }
            privateKey = json.getString("private_key");
            serviceAccountId = json.getString("client_email");
        } else {
            model.put("missingJson", true);
            if (serviceAccountEmail != null) {
                serviceAccountId = serviceAccountEmail;
            }
            if (privateKeyParam != null) {
                privateKey = privateKeyParam;
            }
        }
        model.put("privateKey", privateKey);
        model.put("serviceAccountEmail", serviceAccountId);
        HashSet<String> missingFields = new HashSet<String>();
        model.put("missingFields", missingFields);
        if (domainName.isEmpty()) {
            missingFields.add("domain");
        }
        if (serviceAccountId == null || serviceAccountId.isEmpty() || privateKey == null || privateKey.isEmpty()) {
            missingFields.add("jsonFile");
        }
        if (adminAccountAddress.isEmpty()) {
            missingFields.add("adminAccountAddress");
        }
        if (!missingFields.isEmpty()) {
            return null;
        }
        try {
            GSuiteApi connectorAPI = new GSuiteApi(domainName, customerId, serviceAccountId, adminAccountAddress, privateKey);
            connectorAPI.findAllGroups(new GroupHandler(){

                @Override
                public void handleGroup(GroupItem group) {
                }
            });
            return new GSuiteDirectory(common, domainName, customerId, serviceAccountId, adminAccountAddress, privateKey);
        }
        catch (ConnectorApiException e) {
            model.put("jsonException", e);
            return null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void persist(Directory directory, Element element) {
        GSuiteDirectory dir = (GSuiteDirectory)directory;
        element.setAttribute("domainName", dir.getDomainName());
        element.setAttribute("customerId", dir.getCustomerId().orElse(null));
        element.setAttribute("serviceAccountId", dir.getServiceAccountId());
        element.setAttribute("adminAccountAddress", dir.getAdminAccountAddress());
        Element privateKey = element.getOwnerDocument().createElement("privateKey");
        privateKey.setTextContent(dir.getPrivateKey());
        element.appendChild(privateKey);
    }

    @Override
    public IdpConfiguration.Kind getIdentityProviderKind() {
        return IdpConfiguration.Kind.GOOGLE;
    }

    @Override
    public void editDirectory(HttpServletRequest req, Directory directory, Map<String, Object> model) {
        if (directory != null) {
            GSuiteDirectory dir = (GSuiteDirectory)directory;
            model.put("domainName", dir.getDomainName());
            model.put("customerId", dir.getCustomerId().orElse(""));
            model.put("adminAccountAddress", dir.getAdminAccountAddress());
            model.put("serviceAccountEmail", dir.getServiceAccountId());
        }
    }

    @Override
    public Directory parse(Element element, Directory.Common common) {
        String domainName = element.getAttribute("domainName");
        String customerId = element.getAttribute("customerId");
        String serviceAccountId = element.getAttribute("serviceAccountId");
        String adminAccountAddress = element.getAttribute("adminAccountAddress");
        NodeList privateKeys = element.getElementsByTagName("privateKey");
        String privateKey = privateKeys.getLength() == 0 ? null : privateKeys.item(0).getTextContent();
        return new GSuiteDirectory(common, domainName, customerId, serviceAccountId, adminAccountAddress, privateKey);
    }
}

