/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.connector.crowdserver;

import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationRoundInformation;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.kantega.atlaskerb.connector.admin.CrowdDirectoryFinder;
import org.kantega.atlaskerb.connector.crowdserver.SyncState;
import org.kantega.atlaskerb.connector.model.Directory;
import org.kantega.atlaskerb.connector.model.crowdapi.GroupItem;
import org.kantega.atlaskerb.connector.model.crowdapi.MembershipItem;
import org.kantega.atlaskerb.connector.model.crowdapi.UserItem;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncStateRegistry {
    private static final Logger log = LoggerFactory.getLogger(SyncStateRegistry.class);
    private final CrowdDirectoryFinder crowdDirectoryFinder;
    private final DirectoryManager directoryManager;
    private ConcurrentHashMap<String, SyncState> state = new ConcurrentHashMap();

    public SyncStateRegistry(HostApp hostApp) {
        this.directoryManager = hostApp.getDirectoryManager();
        this.crowdDirectoryFinder = new CrowdDirectoryFinder(hostApp);
    }

    public Optional<SyncState> getState(String connectorId, long correlationId) {
        SyncState syncState = this.state.get(connectorId);
        if (syncState == null || syncState.getCorrelationId() != correlationId) {
            return Optional.empty();
        }
        return Optional.of(syncState);
    }

    public void pruneStates(List<String> activeIds) {
        this.state.keySet().removeIf(key -> !activeIds.contains(key));
    }

    public void createSyncState(Directory directory, Set<UserItem> users, Set<GroupItem> groups2, Set<MembershipItem> memberships) {
        String connectorId = directory.getId();
        com.atlassian.crowd.embedded.api.Directory cwd = this.crowdDirectoryFinder.findDirectory(connectorId);
        long correlationId = this.getCorrelationId(cwd);
        log.debug("Creating sync state {} {}", (Object)connectorId, (Object)correlationId);
        this.state.put(connectorId, new SyncState(correlationId, users, groups2, memberships));
    }

    public SyncState getSyncState(Directory directory) {
        com.atlassian.crowd.embedded.api.Directory cwd = this.crowdDirectoryFinder.findDirectory(directory.getId());
        long correlationId = this.getCorrelationId(cwd);
        return this.getState(directory.getId(), correlationId).orElseThrow(() -> new RuntimeException("SyncState for connector " + directory.getId() + " and correlationId " + correlationId + " not found"));
    }

    public Optional<SyncState> peekSyncState(Directory directory) {
        com.atlassian.crowd.embedded.api.Directory cwd = this.crowdDirectoryFinder.findDirectory(directory.getId());
        long correlationId = this.getCorrelationId(cwd);
        return this.getState(directory.getId(), correlationId);
    }

    public long getCorrelationId(com.atlassian.crowd.embedded.api.Directory directory) {
        try {
            DirectorySynchronisationInformation syncInfo = this.directoryManager.getDirectorySynchronisationInformation(directory.getId().longValue());
            DirectorySynchronisationRoundInformation activeRound = syncInfo.getActiveRound();
            if (activeRound == null) {
                log.debug("No ActiveRound state, trying LastRound");
                DirectorySynchronisationRoundInformation lastRound = syncInfo.getLastRound();
                if (lastRound == null) {
                    log.debug("No LastRound or ActiveRound state, returning 0");
                    return 0L;
                }
                return lastRound.getStartTime();
            }
            return activeRound.getStartTime();
        }
        catch (DirectoryInstantiationException | DirectoryNotFoundException e) {
            throw new RuntimeException("Could not obtain directory sync information", e);
        }
    }
}

