/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.bitbucket;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.http.RepositoryUrlFragment;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;

@Scanned
public class KerberosCloneUrlContextProvider
implements ContextProvider {
    private final ApplicationProperties applicationProperties;

    @Inject
    public KerberosCloneUrlContextProvider(@ComponentImport ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> map) {
        try {
            URI baseUri = new URI(this.applicationProperties.getBaseUrl(UrlMode.CANONICAL).toLowerCase());
            Repository repository = (Repository)map.get("repository");
            String path = RepositoryUrlFragment.fromRepository((Repository)repository).toPath(baseUri.getPath() + "/kerberos-scm");
            URI cloneUrl = new URI(baseUri.getScheme(), ":", baseUri.getHost(), baseUri.getPort(), path + ".git", baseUri.getQuery(), baseUri.getFragment());
            return Collections.singletonMap("cloneUrl", cloneUrl.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

