/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apitokens;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RegexValidationUtil;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.apitokens.ApiTokenObject;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.utils.ListParseUtils;

public class ApiTokenMainServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final ApiTokenService apiTokenService;
    private final KerbConfManager kerbConfManager;
    private final HostApp hostApp;

    @Inject
    public ApiTokenMainServlet(RequireAdminServletDependencyBucket bucket, ApiTokenService apiTokenService) {
        super(bucket);
        this.userManager = bucket.getUserManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.apiTokenService = apiTokenService;
        this.kerbConfManager = bucket.getKerbConfManager();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        java.util.Map<String, Object> model = this.buildModel(req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-main.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.kerbConfManager.isKssoVersionChanged();
        Map<String, Object> protoModel = HashMap.empty();
        if (req.getParameter("setApiTokens") != null) {
            String apiTokens = req.getParameter("apiTokens");
            this.kerbConfManager.setApiTokensEnabled("on".equals(apiTokens));
        }
        protoModel = ((HashMap)protoModel).merge(this.setUserPermissions(req, resp, (HashMap<String, Object>)protoModel));
        protoModel = ((HashMap)protoModel).merge(this.setIpRestrictions(req, resp, (HashMap<String, Object>)protoModel));
        if (!((HashMap)(protoModel = ((HashMap)protoModel).merge(this.setTimeRestriction(req, resp, (HashMap<String, Object>)protoModel)))).isEmpty()) {
            return;
        }
        this.buildModelAndRenderTemplate(req, resp, ((HashMap)protoModel).toJavaMap());
    }

    private HashMap<String, Object> setTimeRestriction(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> protoModel) throws IOException {
        if (req.getParameter("userMaxValidFor") != null) {
            String userTokenLifetimeRestriction = req.getParameter("userMaxValidFor");
            if (!ApiTokenUtil.Validation.validTokenTimeLimit(userTokenLifetimeRestriction)) {
                Map returnProto = protoModel.put((Object)"invalidTokenTimeLimitError", (Object)true);
                this.buildModelAndRenderTemplate(req, resp, ((HashMap)returnProto).toJavaMap());
                return returnProto;
            }
            this.kerbConfManager.setApiTokensUserMaxTimeRestriction(userTokenLifetimeRestriction);
        }
        return protoModel;
    }

    private HashMap<String, Object> setUserPermissions(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> protoModel) throws IOException {
        Try<ApiTokenUtil.TokenUserPermission> userPermission;
        if (req.getParameter("apiTokenUserPermission") != null && (userPermission = Try.of(() -> ApiTokenUtil.TokenUserPermission.valueOf(req.getParameter("apiTokenUserPermission")))).isSuccess()) {
            this.kerbConfManager.setApiTokenUserPermission(userPermission.get());
            if (userPermission.get() == ApiTokenUtil.TokenUserPermission.USER_GROUPS) {
                String commaSeparatedAllowedUserGroups = req.getParameter("apiTokenAllowedUserGroups");
                if (commaSeparatedAllowedUserGroups == null || StringUtils.isBlank((String)commaSeparatedAllowedUserGroups)) {
                    this.kerbConfManager.setApiTokenAllowedUserGroups("");
                    Map returnProto = ((HashMap)protoModel.put((Object)"userGroupsEmptyWarning", (Object)true)).put("apiTokenUserPermission", userPermission.get().name());
                    this.buildModelAndRenderTemplate(req, resp, ((HashMap)returnProto).toJavaMap());
                    return returnProto;
                }
                this.kerbConfManager.setApiTokenAllowedUserGroups(commaSeparatedAllowedUserGroups);
            }
        }
        return protoModel;
    }

    private String invalidGroupName(List<String> allowedUserGroups) {
        Option<String> maybeNotExistingGroup = io.vavr.collection.List.ofAll(allowedUserGroups).find(g -> !this.hostApp.isExistingGroup((String)g));
        return maybeNotExistingGroup.getOrElse("");
    }

    private HashMap<String, Object> setIpRestrictions(HttpServletRequest req, HttpServletResponse resp, HashMap<String, Object> protoModel) throws IOException {
        if (req.getParameter("setIpRestrictions") != null) {
            String ipRestrictionTypeParam = req.getParameter("ipRestrictionType");
            String ipUnblockedList = req.getParameter("token_ip_unblockedlist");
            String ipBlockedList = req.getParameter("token_ip_blockedlist");
            KerbConfManager.IpRestrictionType ipRestrictionType = KerbConfManager.IpRestrictionType.getValueByNameOrAlias(ipRestrictionTypeParam);
            this.kerbConfManager.setApiTokenIpRestrictionType(ipRestrictionType);
            Map returnProto = HashMap.empty();
            if (ipUnblockedList.isEmpty() && ipRestrictionType.equals((Object)KerbConfManager.IpRestrictionType.UNBLOCKEDLIST) || ipBlockedList.isEmpty() && ipRestrictionType.equals((Object)KerbConfManager.IpRestrictionType.BLOCKEDLIST)) {
                returnProto = protoModel.put((Object)"emptyIpList", (Object)("The " + ipRestrictionType.stringValue() + " is empty. The restriction will not work unless you have added values."));
            }
            boolean isValidRegexUnblockedList = RegexValidationUtil.validRegex(ipUnblockedList);
            boolean isValidRegexBlockedList = RegexValidationUtil.validRegex(ipBlockedList);
            if (!isValidRegexUnblockedList || !isValidRegexBlockedList) {
                returnProto = ((HashMap)returnProto).merge(protoModel.put((Object)"tokenRegexError", (Object)"true"));
                returnProto = ((HashMap)returnProto).put("tokenIpUnblockedList", ipUnblockedList);
                returnProto = ((HashMap)returnProto).put("tokenIpBlockedList", ipBlockedList);
                returnProto = !isValidRegexBlockedList ? ((HashMap)returnProto).put("tokenRegexFailedList", "blocked list") : ((HashMap)returnProto).put("tokenRegexFailedList", "unblocked list");
                this.buildModelAndRenderTemplate(req, resp, ((HashMap)returnProto).toJavaMap());
                return returnProto;
            }
            this.kerbConfManager.setApiTokenIpUnblockedlist(ipUnblockedList);
            this.kerbConfManager.setApiTokenIpBlockedlist(ipBlockedList);
            if (!((HashMap)returnProto).isEmpty()) {
                this.buildModelAndRenderTemplate(req, resp, ((HashMap)returnProto).toJavaMap());
                return returnProto;
            }
        }
        return protoModel;
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, java.util.Map<String, Object> protoModel) throws IOException {
        java.util.Map<String, Object> model = this.buildModel(req);
        model.putAll(protoModel);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-main.vm", model, (Writer)resp.getWriter());
    }

    private java.util.Map<String, Object> buildModel(HttpServletRequest req) {
        java.util.Map<String, Object> model = this.newModel(req);
        IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
        model.put("topMenu", "api-tokens");
        model.put("menuItem", "api-tokens-main");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("durationOptions", ApiTokenUtil.DatePair.getDurationOptions());
        model.put("isApiTokensEnabled", this.kerbConfManager.isApiTokensEnabled());
        model.put("tokenIpRestrictionType", ipRestrictionConfig.getApiTokenRestrictionType().name());
        model.put("tokenIpUnblockedList", KerbConfManager.arrayToString(ipRestrictionConfig.getApiTokenIpUnblockedList()));
        model.put("tokenIpBlockedList", KerbConfManager.arrayToString(ipRestrictionConfig.getApiTokenIpBlockedList()));
        model.put("isRestApiRestrictedToToken", this.kerbConfManager.isRestApiRestrictedToApiTokens());
        ApiTokenUtil.TokenUserPermission tokenUserPermission = this.kerbConfManager.getApiTokenUserPermission();
        model.put("apiTokenUserPermission", (Object)tokenUserPermission);
        String commaSeparatedAllowedGroups = ListParseUtils.iterableToCommaSeparatedString(this.kerbConfManager.getApiTokenAllowedUserGroups());
        model.put("allowedUserGroups", commaSeparatedAllowedGroups);
        if (StringUtils.isBlank((String)commaSeparatedAllowedGroups) && tokenUserPermission == ApiTokenUtil.TokenUserPermission.USER_GROUPS) {
            model.put("userGroupsEmptyWarning", true);
        }
        model.put("apiTokensUserMaxTimeRestriction", this.kerbConfManager.getApiTokensUserMaxTimeRestriction());
        String invalidGroupName = this.invalidGroupName(this.kerbConfManager.getApiTokenAllowedUserGroups());
        if (!invalidGroupName.isEmpty()) {
            model.put("invalidGroupName", invalidGroupName);
        }
        Option.of(this.userManager.getRemoteUser(req)).map(UserProfile::getUsername).forEach(username -> model.put("username", username));
        model.put("tokens", this.getTokensRepresentation());
        return model;
    }

    private List<ApiTokenUtil.ApiTokenRepresentation> getTokensRepresentation() {
        return io.vavr.collection.List.ofAll(this.apiTokenService.findAllTokens()).map(t -> new ApiTokenUtil.ApiTokenRepresentation((ApiTokenObject)t, this.userManager, this.kerbConfManager, this.apiTokenService)).toJavaList();
    }
}

