/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apitokens;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.apitokens.ApiTokenObject;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.apitokens.ApiTokenUtil;
import org.kantega.atlaskerb.hostapp.HostApp;

@Scanned
public class ApiTokenAdminServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final UserManager userManager;
    private final ApiTokenService apiTokenService;
    private final KerbConfManager kerbConfManager;
    private final HostApp hostApp;

    @Inject
    public ApiTokenAdminServlet(RequireAdminServletDependencyBucket bucket, ApiTokenService apiTokenService) {
        super(bucket);
        this.userManager = bucket.getUserManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.apiTokenService = apiTokenService;
        this.kerbConfManager = bucket.getKerbConfManager();
        this.hostApp = bucket.getHostAppFactory().getInstance();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        java.util.Map<String, Object> model = this.buildModel(req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-admin.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.kerbConfManager.isKssoVersionChanged();
        Map protoModel = HashMap.empty();
        if (req.getParameter("setApiTokens") != null) {
            String apiTokens = req.getParameter("apiTokens");
            this.kerbConfManager.setApiTokensEnabled("on".equals(apiTokens));
        }
        if (!((HashMap)protoModel).isEmpty()) {
            return;
        }
        if ("delete".equals(req.getParameter("operation"))) {
            Option.of(req.getParameter("tokenId")).map(this.apiTokenService::findTokenById).filter(Objects::nonNull).forEach(this.apiTokenService::delete);
            this.buildModelAndRenderTemplate(req, resp, ((HashMap)protoModel).toJavaMap());
        } else {
            Option<String> maybeToken = this.apiTokenService.createAndPersistToken(req);
            if (maybeToken.isDefined()) {
                protoModel = ((HashMap)protoModel).merge(((HashMap)protoModel).put("newApiToken", maybeToken.get()));
            }
            this.buildModelAndRenderTemplate(req, resp, ((HashMap)protoModel).toJavaMap());
        }
    }

    private void buildModelAndRenderTemplate(HttpServletRequest req, HttpServletResponse resp, java.util.Map<String, Object> protoModel) throws IOException {
        java.util.Map<String, Object> model = this.buildModel(req);
        model.putAll(protoModel);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-admin.vm", model, (Writer)resp.getWriter());
    }

    private java.util.Map<String, Object> buildModel(HttpServletRequest req) {
        java.util.Map<String, Object> model = this.newModel(req);
        IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
        model.put("topMenu", "api-tokens");
        model.put("menuItem", "api-tokens");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("durationOptions", ApiTokenUtil.DatePair.getDurationOptions());
        model.put("isApiTokensEnabled", this.kerbConfManager.isApiTokensEnabled());
        model.put("tokens", this.getTokensRepresentation());
        return model;
    }

    private List<ApiTokenUtil.ApiTokenRepresentation> getTokensRepresentation() {
        return io.vavr.collection.List.ofAll(this.apiTokenService.findAllTokens()).map(t -> new ApiTokenUtil.ApiTokenRepresentation((ApiTokenObject)t, this.userManager, this.kerbConfManager, this.apiTokenService)).toJavaList();
    }
}

