/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.apitokens;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.restapi.access.TokenEndpointService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiTokenAccessServlet
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final TokenEndpointService tokenEndpointService;
    private final KerbConfManager kerbConfManager;
    private final HostApp hostApp;
    private final String REST;
    private final Logger log = LoggerFactory.getLogger(ApiTokenAccessServlet.class);

    public ApiTokenAccessServlet(RequireAdminServletDependencyBucket bucket, TokenEndpointService tokenEndpointService) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.tokenEndpointService = tokenEndpointService;
        this.kerbConfManager = bucket.getKerbConfManager();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.REST = this.hostApp.isProductMatch("fecru") ? "/rest-service-fecru" : "/rest";
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.buildModel(req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-access.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String addUrl;
        String removeUrl = req.getParameter("removeUrl");
        if (StringUtils.isNotBlank((String)removeUrl)) {
            this.kerbConfManager.removeApiTokenAccessUrls(removeUrl);
        }
        if (StringUtils.isNotBlank((String)(addUrl = req.getParameter("addUrl")))) {
            addUrl = addUrl.trim();
            String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
            addUrl = StringUtils.removeStart((String)addUrl, (String)baseUrl);
            addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"https://"));
            if (!StringUtils.startsWith((String)(addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"http://"))), (String)"/")) {
                addUrl = "/" + addUrl;
            }
            this.kerbConfManager.addApiTokenAccessUrls(addUrl);
        }
        Map<String, Object> model = this.buildModel(req);
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/api-tokens-access.vm", model, (Writer)resp.getWriter());
    }

    private Map<String, Object> buildModel(HttpServletRequest req) {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "api-tokens");
        model.put("menuItem", "api-tokens-access");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("actualBaseUrl", this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
        model.put("isFecru", this.hostApp.isProductMatch("fecru"));
        model.put("isApiTokensEnabled", this.kerbConfManager.isApiTokensEnabled());
        model.put("apiAccessUrls", this.kerbConfManager.getApiTokenAccessUrls());
        return model;
    }
}

