/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.AtlasKerberosFilter;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.utils.HttpUrlUtils;

@Scanned
public class UsernameFromHeaderAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public UsernameFromHeaderAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "usernameFromHeader");
        model.put("displayName", this.applicationProperties.getDisplayName());
        String usernameAttribute = this.kerbConfManager.getHeaderUsernameAttribute();
        String emailAttribute = this.kerbConfManager.getHeaderEmailAttribute();
        String unblockedlist = this.kerbConfManager.getHeaderUsernameIpUnblockedlistAsString();
        boolean usernameEnabled = StringUtils.isNotBlank(unblockedlist) && StringUtils.isNotBlank(usernameAttribute);
        boolean emailEnabled = StringUtils.isNotBlank(unblockedlist) && StringUtils.isNotBlank(emailAttribute);
        usernameAttribute = StringUtils.isBlank(usernameAttribute) ? "username-from-header" : usernameAttribute;
        emailAttribute = StringUtils.isBlank(emailAttribute) ? "email-from-header" : emailAttribute;
        unblockedlist = StringUtils.isBlank(unblockedlist) ? "127.0.0.1" : unblockedlist;
        model.put("headerUsernameAttribute", usernameAttribute);
        model.put("headerEmailAttribute", emailAttribute);
        model.put("headerUsernameIpUnblockedlist", unblockedlist);
        model.put("enableUsernameFromHeader", usernameEnabled);
        model.put("enableEmailFromHeader", emailEnabled);
        model.put("remoteAddr", req.getRemoteAddr());
        if (this.kerbConfManager.isHeaderauthUseXForwardedFor()) {
            model.put("remoteAddr", AtlasKerberosFilter.getRemoteIp(req));
        }
        model.put("hasRemoteIpValve", HttpUrlUtils.isRemoteIpValveConfigured());
        model.put("isJsdInstalled", this.kerbConfManager.isJsdInstalled());
        model.put("isHeaderauthUseXForwardedFor", this.kerbConfManager.isHeaderauthUseXForwardedFor());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/usernameFromHeader.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean usernameEnabled = "on".equals(req.getParameter("enableUsernameFromHeader"));
        boolean emailEnabled = "on".equals(req.getParameter("enableEmailFromHeader"));
        if (usernameEnabled) {
            this.kerbConfManager.setHeaderUsernameAttribute(req.getParameter("headerUsernameAttribute"));
        } else {
            this.kerbConfManager.setHeaderUsernameAttribute(null);
        }
        if (emailEnabled) {
            this.kerbConfManager.setHeaderEmailAttribute(req.getParameter("headerEmailAttribute"));
        } else {
            this.kerbConfManager.setHeaderEmailAttribute(null);
        }
        if (usernameEnabled || emailEnabled) {
            this.kerbConfManager.setHeaderUsernameIpUnblockedlist(req.getParameter("headerUsernameIpUnblockedlist"));
            this.kerbConfManager.setHeaderauthUseXForwardedFor("on".equals(req.getParameter("setHeaderauthUseXForwardedFor")));
        } else {
            this.kerbConfManager.setHeaderUsernameIpUnblockedlist(null);
            this.kerbConfManager.setHeaderauthUseXForwardedFor(false);
        }
        resp.sendRedirect("usernameFromHeader");
    }
}

