/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserdetailsInCommentRequestWrapper
extends HttpServletRequestWrapper {
    private static final String COMMENT_PARAMETER = "comment";
    private final String userdetails;
    private final String postedUserDetails;
    private final boolean overrideInputstream;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final HttpServletRequest request;

    public UserdetailsInCommentRequestWrapper(HttpServletRequest request, String userdetails, boolean overrideInputstream) throws IOException {
        super(request);
        this.userdetails = userdetails;
        this.overrideInputstream = overrideInputstream;
        this.postedUserDetails = "Posted by: " + userdetails;
        this.request = request;
    }

    public String[] getParameterValues(String name) {
        String[] values2 = this.request.getParameterValues(name);
        if (COMMENT_PARAMETER.equals(name) && values2 != null && values2.length > 0) {
            values2[0] = this.userdetails != null ? values2[0] + "\r\n\r\n" + this.postedUserDetails : null;
        }
        return values2;
    }

    public String getParameter(String name) {
        String parameter = this.request.getParameter(name);
        if (COMMENT_PARAMETER.equals(name)) {
            return parameter + "\r\n\r\n" + this.postedUserDetails;
        }
        return parameter;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.overrideInputstream) {
            String body;
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                ServletInputStream inputStream2 = this.request.getInputStream();
                if (inputStream2 != null) {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream2));
                    char[] charBuffer = new char[128];
                    int bytesRead = -1;
                    while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                        stringBuilder.append(charBuffer, 0, bytesRead);
                    }
                } else {
                    stringBuilder.append("");
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                String body2 = stringBuilder.toString();
            }
            if (this.userdetails != null && body.matches(".*\"body\".*:.*\".*\".*")) {
                this.log.debug("Adding user details to anonymous comment: " + this.userdetails);
                body = body.replaceFirst("(.*\"body\".*:.*\")(.*)(\".*)", "$1$2\\\\r\\\\n\\\\r\\\\n" + this.postedUserDetails + "$3");
            } else if (this.userdetails == null) {
                body = "";
                this.log.debug("Storing empty anonymous comment (which is not saved) since userdetails are null which indicates no identity was found using Kerberos");
            } else {
                body = "";
                this.log.warn("Storing empty anonymous comment since comment format was of unknown type: " + body);
            }
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body.getBytes());
            ServletInputStream servletInputStream = new ServletInputStream(){

                public boolean isFinished() {
                    return false;
                }

                public boolean isReady() {
                    return false;
                }

                public void setReadListener(ReadListener readListener) {
                }

                public int read() throws IOException {
                    return byteArrayInputStream.read();
                }
            };
            return servletInputStream;
        }
        return this.request.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }
}

