/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.regextranformation.RegexTransformationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMappingUtils {
    private static final Logger log = LoggerFactory.getLogger(UserMappingUtils.class);

    public static RegexTransformationResult regexTransformPairToResult(String textInput, String regexPattern, String regexReplacement) {
        String transformedUsername = null;
        String regexErrorMessage = null;
        if (StringUtils.isBlank((String)regexPattern) && StringUtils.isBlank((String)regexReplacement)) {
            transformedUsername = "";
            regexErrorMessage = "";
        } else if (StringUtils.isBlank((String)regexPattern) || StringUtils.isBlank((String)regexReplacement)) {
            regexErrorMessage = "Both fields must have a value";
        } else {
            try {
                transformedUsername = UserMappingUtils.interpretRegexAndReplace(textInput, regexPattern, regexReplacement);
            }
            catch (Exception e) {
                regexErrorMessage = e.getMessage();
            }
        }
        return new RegexTransformationResult(textInput, transformedUsername, regexErrorMessage, regexPattern, regexReplacement);
    }

    public static List<RegexTransformationResult> regexTransformations(String userPrincipalName, List<Pair<String, String>> regexTuples) {
        return regexTuples.stream().map(pair -> UserMappingUtils.regexTransformPairToResult(userPrincipalName, (String)pair.getLeft(), (String)pair.getRight())).collect(Collectors.toList());
    }

    public static Optional<String> transformUsername(String username, List<Pair<String, String>> regexTuples) {
        return regexTuples.stream().map(tuple -> UserMappingUtils.regexTransformPairToResult(username, (String)tuple.getLeft(), (String)tuple.getRight())).filter(result -> Objects.nonNull(result.getResult())).findFirst().map(result -> result.getResult());
    }

    private static String interpretRegexAndReplace(String text, String regexPattern, String regexReplacement) {
        String lowerStart = "_lower_case_start_";
        String lowerEnd = "_lower_case_end_";
        String patternLower = "\\\\L";
        String upperStart = "_upper_case_start_";
        String upperEnd = "_upper_case_end_";
        String patternUpper = "\\\\U";
        regexReplacement = regexReplacement.replaceAll(patternLower + "(\\$[\\d])+", lowerStart + "$1" + lowerEnd);
        regexReplacement = regexReplacement.replaceAll(patternUpper + "(\\$[\\d])+", upperStart + "$1" + upperEnd);
        Matcher m = Pattern.compile(regexPattern).matcher(text);
        if (!m.matches()) {
            return null;
        }
        String textReplaced = m.replaceFirst(regexReplacement);
        StringBuilder newText = new StringBuilder();
        try {
            newText = UserMappingUtils.changeCasing(lowerStart, lowerEnd, upperStart, upperEnd, textReplaced, newText);
        }
        catch (Exception e) {
            log.warn("Unable to change casing for username: " + textReplaced);
            return textReplaced;
        }
        return newText.toString();
    }

    @NotNull
    private static StringBuilder changeCasing(String lowerStart, String lowerEnd, String upperStart, String upperEnd, String textReplaced, StringBuilder newText) {
        int i;
        String[] parts2;
        String[] splitted;
        for (String part : splitted = textReplaced.split(lowerStart)) {
            if (part.contains(lowerEnd)) {
                parts2 = part.split(lowerEnd);
                for (i = 0; i < parts2.length; ++i) {
                    if (i == 0) {
                        newText.append(parts2[i].toLowerCase());
                        continue;
                    }
                    newText.append(parts2[i]);
                }
                continue;
            }
            newText.append(part);
        }
        splitted = newText.toString().split(upperStart);
        newText = new StringBuilder();
        for (String part : splitted) {
            if (part.contains(upperEnd)) {
                parts2 = part.split(upperEnd);
                for (i = 0; i < parts2.length; ++i) {
                    if (i == 0) {
                        newText.append(parts2[i].toUpperCase());
                        continue;
                    }
                    newText.append(parts2[i]);
                }
                continue;
            }
            newText.append(part);
        }
        return newText;
    }
}

