/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.prometheus.client.Summary;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.kantega.atlaskerb.AtlDirectoryManager;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PrincipalEntry;
import org.kantega.atlaskerb.UserMappingUtils;
import org.kantega.atlaskerb.UserNameLookup;
import org.kantega.atlaskerb.diagnostics.metrics.KSSOPluginMetrics;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.hostapp.JiraHostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.UsernameSearchResult;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UserLookupService
implements DebugInfo {
    protected static final String KSSO_TRADITIONAL_LOGIN_ALLOWED = "ksso.traditional.login.allowed";
    protected static final String KSSO_KERBEROS_LOGIN_ALLOWED = "ksso.kerberos.login.allowed";
    private static final Logger log = LoggerFactory.getLogger(UserLookupService.class);
    private final UserManager userManager;
    private final KerbConfManager kerbConfManager;
    private final IdpConfManager idpConfManager;
    private final AtlDirectoryManager directoryManager;
    private final HostApp hostApp;
    private final Map<String, Boolean> activeDirectoryCache = new ConcurrentHashMap<String, Boolean>();

    @Inject
    public UserLookupService(@ComponentImport UserManager userManager, KerbConfManager kerbConfManager, HostAppFactory hostAppFactory, AtlDirectoryManager directoryManager, IdpConfManager idpConfManager) {
        this.userManager = userManager;
        this.kerbConfManager = kerbConfManager;
        this.directoryManager = directoryManager;
        this.hostApp = hostAppFactory.getInstance();
        this.idpConfManager = idpConfManager;
    }

    public PrincipalEntry lookupUser(String userPrincipalName, boolean addDefaultGroups) {
        for (Directory directory : this.getActiveUserDirectories()) {
            Set<String> lookupNames = this.findLookupNames(userPrincipalName, directory);
            for (String username : lookupNames) {
                PrincipalEntry principalEntry = this.resolveUserInDirectory(directory, username, addDefaultGroups);
                if (principalEntry.getUserState() == PrincipalEntry.UserState.NOT_FOUND || principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE) continue;
                return principalEntry;
            }
        }
        Set<String> fallbackNames = this.getAccountNamesForLookup(userPrincipalName);
        log.debug("Looking up fallback users: {}", fallbackNames);
        return this.resolveUser(fallbackNames);
    }

    @NotNull
    private PrincipalEntry resolveUser(Set<String> lookupNames) {
        CrowdService crowdService = this.hostApp.getCrowdService();
        for (String username : lookupNames) {
            User user = crowdService.getUser(username);
            if (user == null) continue;
            log.debug("Resolved user {}", (Object)username);
            PrincipalEntry.UserState state = user.isActive() ? PrincipalEntry.UserState.FOUND : PrincipalEntry.UserState.INACTIVE;
            return new PrincipalEntry(this.userManager.resolve(username), state);
        }
        log.debug("No users resolved");
        return new PrincipalEntry(null, PrincipalEntry.UserState.NOT_FOUND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrincipalEntry resolveUserInDirectory(Directory directory, String username, boolean addDefaultGroups) {
        try (Summary.Timer timer = KSSOPluginMetrics.resolveUserInDirectoryLatency.startTimer();){
            com.atlassian.crowd.model.user.User user = this.hostApp.getDirectoryManager().findUserByName(directory.getId().longValue(), username);
            if (directory.getType() == DirectoryType.CROWD || directory.getType() == DirectoryType.CONNECTOR) {
                this.hostApp.optionallyUpdateUserFromRemoteDirectory(user.getName(), directory, this.isNewlyCreatedUser(user));
                if (directory.getType() == DirectoryType.CROWD) {
                    this.hostApp.optionallyAddCrowdGroups(user);
                }
            } else if (directory.getType() == DirectoryType.DELEGATING && !this.isJITDirectory(directory.getId())) {
                this.hostApp.optionallyUpdateDelegatedUser(directory, user);
            }
            if (user.isActive()) {
                PrincipalEntry principalEntry = new PrincipalEntry(this.userManager.resolve(username), PrincipalEntry.UserState.FOUND);
                if (addDefaultGroups && principalEntry.getPrincipal().isPresent() && "true".equals(directory.getAttributes().get("ksso.default.groups.enabled"))) {
                    this.hostApp.setDefaultGroups(principalEntry.getPrincipal().get(), directory);
                }
                PrincipalEntry principalEntry2 = principalEntry;
                return principalEntry2;
            }
            PrincipalEntry principalEntry = new PrincipalEntry(this.userManager.resolve(username), PrincipalEntry.UserState.INACTIVE);
            return principalEntry;
        }
        return new PrincipalEntry(null, PrincipalEntry.UserState.NOT_FOUND);
    }

    public PrincipalEntry resolveUserInDirectories(String username, boolean addDefaultGroups) {
        for (Directory directory : this.getActiveUserDirectories()) {
            PrincipalEntry principalEntry = this.resolveUserInDirectory(directory, username, addDefaultGroups);
            if (principalEntry.getUserState() == PrincipalEntry.UserState.NOT_FOUND) continue;
            return principalEntry;
        }
        Set<String> fallbackNames = this.getAccountNamesForLookup(username);
        log.debug("Looking up fallback users: {}", fallbackNames);
        return this.resolveUser(fallbackNames);
    }

    private boolean isNewlyCreatedUser(com.atlassian.crowd.model.user.User user) {
        boolean newlyCreatedUser = true;
        if (user instanceof TimestampedUser) {
            TimestampedUser tUser = (TimestampedUser)user;
            Instant creationInstant = tUser.getCreatedDate().toInstant();
            if (creationInstant.isBefore(Instant.now().minusSeconds(60L))) {
                newlyCreatedUser = false;
            }
        } else {
            log.debug("User {} not instance of TimestampedUser ({}); cannot determine if newly created", (Object)user.getName(), user.getClass());
        }
        return newlyCreatedUser;
    }

    public Set<String> findLookupNames(String userPrincipalName, Directory directory) {
        return this.determineLookupNames(userPrincipalName, directory, this.kerbConfManager.getRegexLookup(), this.kerbConfManager.getRegexReplacement(), this.kerbConfManager.getAdditionalUserSuffix());
    }

    Set<String> determineLookupNames(String userPrincipalName, Directory directory, String regexLookup, String regexReplacement, String additionalUserSuffix) {
        LinkedHashSet<String> lookupNames = new LinkedHashSet<String>();
        String transformedPrincipalName = UserMappingUtils.regexTransformPairToResult(userPrincipalName, regexLookup, regexReplacement).getResult();
        if (StringUtils.isNotBlank((String)transformedPrincipalName)) {
            lookupNames.add(transformedPrincipalName);
        }
        if (this.isMicrosoftActiveDirectory(directory)) {
            if (UserLookupService.isUpnRealmMatchesDirectory(userPrincipalName, directory)) {
                String userPart = userPrincipalName.substring(0, userPrincipalName.lastIndexOf("@"));
                if (userPart.contains("@")) {
                    String userName = new UserNameLookup(directory.getAttributes(), this.hostApp).lookupUserNameFromUserPrincipalName(userPart);
                    if (StringUtils.isNotBlank((String)userName)) {
                        lookupNames.add(userName);
                    }
                } else if (this.isNonStandardUsernameDirectory(directory)) {
                    String userName = new UserNameLookup(directory.getAttributes(), this.hostApp).lookupUserNameFromSamAccountNameAtRealm(userPrincipalName);
                    if (StringUtils.isNotBlank((String)userName)) {
                        lookupNames.add(userName);
                    }
                } else {
                    lookupNames.add(userPrincipalName.substring(0, userPrincipalName.indexOf("@")));
                }
            }
        } else {
            Set<String> usernames = this.getAccountNamesForLookup(userPrincipalName, additionalUserSuffix);
            lookupNames.addAll(usernames);
        }
        return lookupNames;
    }

    static boolean isUpnRealmMatchesDirectory(String userPrincipalName, Directory directory) {
        Map attributes = directory.getAttributes();
        String baseDn = (String)attributes.get("ldap.basedn");
        String userDn = (String)attributes.get("ldap.user.dn");
        if (StringUtils.isBlank((String)baseDn)) {
            return false;
        }
        String searchBase = baseDn;
        if (StringUtils.isNotBlank((String)userDn)) {
            searchBase = userDn + "," + baseDn;
        }
        String realm = userPrincipalName.substring(userPrincipalName.lastIndexOf("@") + 1);
        return UserLookupService.isRealmMatchesLdapName(realm, baseDn, searchBase);
    }

    static boolean isRealmMatchesLdapName(String realm, String baseDn, String searchBase) {
        try {
            String normalizedBaseDn = UserLookupService.toNormalizedDomainName(new LdapName(baseDn));
            String normalizedSearchBase = UserLookupService.toNormalizedDomainName(new LdapName(searchBase));
            return StringUtils.endsWithIgnoreCase((String)normalizedSearchBase, (String)realm) || StringUtils.endsWithIgnoreCase((String)realm, (String)normalizedBaseDn);
        }
        catch (InvalidNameException e) {
            log.debug("Invalid searchBase {} and baseDn {}. Will be unable to determine match for realm {}", new Object[]{searchBase, baseDn, realm});
            return false;
        }
    }

    private static String toNormalizedDomainName(LdapName ldapName) {
        return ldapName.getRdns().stream().filter(rdn -> StringUtils.equalsIgnoreCase((String)"dc", (String)rdn.getType())).map(rdn -> (String)rdn.getValue()).map(StringUtils::upperCase).reduce("", (a, b) -> StringUtils.isBlank((String)a) ? b : b + "." + a);
    }

    Set<String> getAccountNamesForLookup(String userPrincipalName, String additionalUserSuffix) {
        LinkedHashSet<String> usernames = new LinkedHashSet<String>();
        String username = StringUtils.substringBefore((String)userPrincipalName, (String)"@");
        usernames.addAll(Arrays.asList(username, username.toLowerCase(), username.toUpperCase()));
        usernames.addAll(Arrays.asList(userPrincipalName, userPrincipalName.toLowerCase(), userPrincipalName.toUpperCase()));
        if (additionalUserSuffix != null) {
            String additional = username + "@" + additionalUserSuffix;
            usernames.add(additional);
            usernames.add(additional.toLowerCase());
            usernames.add(additional.toUpperCase());
        }
        return usernames;
    }

    Set<String> getAccountNamesForLookup(String userPrincipalName) {
        LinkedHashSet<String> usernames = new LinkedHashSet<String>();
        String username = StringUtils.substringBefore((String)userPrincipalName, (String)"@");
        usernames.addAll(Arrays.asList(username, username.toLowerCase(), username.toUpperCase()));
        usernames.addAll(Arrays.asList(userPrincipalName, userPrincipalName.toLowerCase(), userPrincipalName.toUpperCase()));
        String additionalSuffix = this.kerbConfManager.getAdditionalUserSuffix();
        if (additionalSuffix != null) {
            String additional = username + "@" + additionalSuffix;
            usernames.add(additional);
            usernames.add(additional.toLowerCase());
            usernames.add(additional.toUpperCase());
        }
        return usernames;
    }

    public List<Directory> getActiveUserDirectories() {
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        for (Directory directory : this.hostApp.getCrowdDirectoryService().findAllDirectories()) {
            if (!directory.isActive()) continue;
            dirs.add(directory);
        }
        return dirs;
    }

    public List<Directory> getDirectoriesAllowingTraditionalLogin() {
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        for (Directory directory : this.getActiveUserDirectories()) {
            if (!"true".equals(directory.getAttributes().get(KSSO_TRADITIONAL_LOGIN_ALLOWED))) continue;
            dirs.add(directory);
        }
        return dirs;
    }

    public List<Directory> getDirectoriesAllowingKerberosLogin() {
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        for (Directory directory : this.getActiveUserDirectories()) {
            if (!"true".equals(directory.getAttributes().get(KSSO_KERBEROS_LOGIN_ALLOWED))) continue;
            dirs.add(directory);
        }
        return dirs;
    }

    private boolean isNonStandardUsernameDirectory(Directory directory) {
        String usernameAttribute = (String)directory.getAttributes().get("ldap.user.username");
        return this.isMicrosoftActiveDirectory(directory) && usernameAttribute != null && !"sAMAccountName".equalsIgnoreCase(usernameAttribute);
    }

    private boolean isMicrosoftActiveDirectory(Directory directory) {
        if (directory.getType() != DirectoryType.DELEGATING && directory.getType() != DirectoryType.CONNECTOR) {
            return false;
        }
        if (this.isDirectoryType(directory, "com.atlassian.crowd.directory.MicrosoftActiveDirectory")) {
            return true;
        }
        if (!this.isDirectoryType(directory, "com.atlassian.crowd.directory.GenericLDAP")) {
            return false;
        }
        String key = UserLookupService.getAdCacheKey(directory);
        Boolean cached = this.activeDirectoryCache.get(key);
        if (Boolean.TRUE.equals(cached)) {
            return true;
        }
        if (Boolean.FALSE.equals(cached)) {
            return false;
        }
        try {
            boolean isAD = this.directoryManager.getDomainDirectory(directory).isActiveDirectory();
            this.activeDirectoryCache.put(key, isAD);
            return isAD;
        }
        catch (NamingException e) {
            return false;
        }
    }

    private boolean isDirectoryType(Directory directory, String type) {
        return directory.getImplementationClass() != null && (type.equals(directory.getImplementationClass()) || directory.getAttributes() != null && "com.atlassian.crowd.directory.MicrosoftActiveDirectory".equals(directory.getAttributes().get("crowd.delegated.directory.type")));
    }

    private static String getAdCacheKey(Directory directory) {
        return directory.getId().toString() + "-" + directory.getUpdatedDate().getTime();
    }

    public boolean isLdapDirectory(Directory directory) {
        return directory.getType() == DirectoryType.CONNECTOR || directory.getType() == DirectoryType.DELEGATING;
    }

    boolean hasWritableCrowdDirectory() {
        for (Directory directory : this.getActiveUserDirectories()) {
            if (directory.getType() != DirectoryType.CROWD || !directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP)) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveLDAPDirectories() {
        for (Directory directory : this.getActiveUserDirectories()) {
            if (!this.isLdapDirectory(directory)) continue;
            return true;
        }
        return false;
    }

    private boolean isJITDirectory(Long directoryId) {
        Iterator<IdpConfiguration> iterator2 = this.idpConfManager.getIdentityProviders().iterator();
        if (iterator2.hasNext()) {
            IdpConfiguration idpConfig = iterator2.next();
            boolean isJITActive = idpConfig.getUserNotFoundPolicy() == IdpConfiguration.UserNotFoundPolicy.CREATE || idpConfig.getUserUpdatePolicy() == IdpConfiguration.UserUpdatePolicy.UPDATE || idpConfig.getUserActivatePolicy() == IdpConfiguration.UserActivatePolicy.ACTIVATE;
            return idpConfig.getJitDirectory().isPresent() && idpConfig.getJitDirectory().get().equals(directoryId) && isJITActive;
        }
        return false;
    }

    public boolean hasUserAccess(HttpServletRequest request) {
        if (!this.hostApp.shouldCheckUserAccess()) {
            return true;
        }
        String userName = this.hostApp.getLoginRequestUsername(request);
        JiraHostApp.CanUseStatus canUseStatus = new JiraHostApp.CanUseStatus(userName).invoke();
        return canUseStatus.hasAnyRole() || canUseStatus.hasGlobalAdminPermission();
    }

    public List<UsernameSearchResult> searchUserAccount(String searchUsername, IdpConfiguration.UserNotFoundPolicy userNotFoundPolicy, IdpConfiguration.UserLookupAttribute userLookupAttribute, boolean addDefaultGroups) {
        ArrayList<UsernameSearchResult> results = new ArrayList<UsernameSearchResult>();
        for (Directory directory : this.getActiveUserDirectories()) {
            PrincipalEntry pe;
            String userLookupName = searchUsername;
            if (this.isLdapDirectory(directory) && userNotFoundPolicy == IdpConfiguration.UserNotFoundPolicy.REJECT && userLookupAttribute != IdpConfiguration.UserLookupAttribute.USERNAME) {
                String ldapUsername = new UserNameLookup(directory.getAttributes(), this.hostApp).lookupUserNameFromAttribute(userLookupAttribute.getAttributeName(), userLookupName);
                if (ldapUsername != null) {
                    userLookupName = ldapUsername;
                } else {
                    results.add(UsernameSearchResult.notFound(directory));
                    continue;
                }
            }
            if ((pe = this.resolveUserInDirectory(directory, userLookupName, addDefaultGroups)).getUserState() != PrincipalEntry.UserState.NOT_FOUND) {
                if (pe.getUserState() == PrincipalEntry.UserState.FOUND && pe.getPrincipal().isPresent()) {
                    String userAccountName = pe.getPrincipal().get().getName();
                    UserProfile userProfile = this.userManager.getUserProfile(userAccountName);
                    results.add(UsernameSearchResult.resolved(directory, pe, userProfile));
                    return results;
                }
                results.add(UsernameSearchResult.inactive(directory, pe));
                continue;
            }
            results.add(UsernameSearchResult.notFound(directory));
        }
        return results;
    }

    @Override
    public JSONObject asJson() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        List directories = io.vavr.collection.List.ofAll(this.getActiveUserDirectories()).map(directory -> {
            JSONObject directoryJson = new JSONObject();
            directoryJson.put("isActive", directory.isActive());
            directoryJson.put("isEmpty", directory.isEmpty());
            directoryJson.put("name", directory.getName());
            directoryJson.put("attributes", new JSONObject(directory.getAttributes()));
            directoryJson.put("directoryType", directory.getType().name());
            directoryJson.put("description", directory.getDescription());
            directoryJson.put("encryptionType", directory.getEncryptionType());
            directoryJson.put("id", directory.getId());
            directoryJson.put("updatedDate", dateFormat.format(directory.getUpdatedDate().getTime()));
            directoryJson.put("createdDate", dateFormat.format(directory.getCreatedDate().getTime()));
            directoryJson.put("isAlwaysSyncGroups", this.hostApp.isAlwaysSyncGroups((Directory)directory));
            directoryJson.put("isSyncGroupsOnFirstCreated", this.hostApp.isSyncGroupsOnFirstCreated((Directory)directory));
            return directoryJson;
        }).toJavaList();
        JSONObject json = new JSONObject();
        json.put("directories", directories);
        return json;
    }

    protected boolean userInAllowedDirectoryOrGroup(HttpServletRequest req, List<Directory> dirsAllowing, HostApp hostApp, Set<String> allowingLoginGroups, Set<String> disallowingLoginGroups, String username) {
        try {
            List<UsernameSearchResult> usernameSearchResult = null;
            if (username != null) {
                usernameSearchResult = this.searchUserAccount(username, IdpConfiguration.UserNotFoundPolicy.REJECT, IdpConfiguration.UserLookupAttribute.USERNAME, false);
            }
            if (usernameSearchResult != null) {
                UsernameSearchResult userFound = null;
                for (UsernameSearchResult usernameSearchResult2 : usernameSearchResult) {
                    if (usernameSearchResult2 == null || usernameSearchResult2.getUserProfile() == null) continue;
                    userFound = usernameSearchResult2;
                }
                if (userFound != null) {
                    Directory usernameDirectory = userFound.getDirectory();
                    for (Directory dir : dirsAllowing) {
                        if (!dir.getId().equals(usernameDirectory.getId())) continue;
                        return true;
                    }
                    for (String group : allowingLoginGroups) {
                        if (!hostApp.isUserInGroup(username, group)) continue;
                        return true;
                    }
                    if (disallowingLoginGroups.size() > 0) {
                        boolean bl;
                        boolean bl2 = true;
                        for (String group : disallowingLoginGroups) {
                            if (!hostApp.isUserInGroup(username, group)) continue;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            return true;
                        }
                    }
                }
            }
        }
        catch (RuntimeException r) {
            log.error(ErrorUtils.createErrorMessage("KSSO-KILKDR1VEI", "Problem when searching for user in directory: " + r));
        }
        return false;
    }
}

