/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.control.Option;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.SnapshotService;

@Scanned
public class SnapshotsAction
extends RequireAdminServlet {
    private final SnapshotService snapshotService;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public SnapshotsAction(RequireAdminServletDependencyBucket bucket, SnapshotService snapshotService) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.snapshotService = snapshotService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("restored", req.getParameter("restored"));
        this.renderPage(resp, model);
    }

    private void renderPage(HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        model.put("topMenu", "dashboard");
        model.put("menuItem", "snapshots");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("snapshots", this.snapshotService.getSnapshots());
        model.put("dateTool", new DateTool());
        File snapshotsDirectory = this.snapshotService.getSnapshotsDirectory();
        snapshotsDirectory.mkdirs();
        model.put("snapshotDirectory", snapshotsDirectory.getAbsolutePath());
        model.put("snapshotDirectoryExists", snapshotsDirectory.exists());
        model.put("snapshotDirectoryReadable", snapshotsDirectory.canRead());
        this.renderer.render("templates/atlaskerb/snapshots.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap errors = new HashMap();
        String filenameInput = FilenameUtils.getName((String)req.getParameter("filename"));
        if (req.getParameter("delete") != null) {
            Option<File> maybeFile = this.snapshotService.getSnapshotFile(filenameInput);
            if (maybeFile.isDefined()) {
                maybeFile.get().delete();
            }
        } else if (req.getParameter("restore") != null) {
            resp.sendRedirect("restore-snapshot?filename=" + filenameInput);
            return;
        }
        if (!errors.isEmpty()) {
            Map<String, Object> model = this.newModel(req);
            model.putAll(errors);
            this.renderPage(resp, model);
        } else {
            resp.sendRedirect("snapshots");
        }
    }
}

