/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;

@Scanned
public class RememberMeCookiesAction
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final HostApp hostApp;
    private ApplicationProperties applicationProperties;
    private KerbConfManager kerbConfManager;

    @Inject
    public RememberMeCookiesAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.applicationProperties = bucket.getApplicationProperties();
        this.kerbConfManager = bucket.getKerbConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "rememberme-cookies");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("remembermeCookieEnabled", this.kerbConfManager.isRemembermeCookieEnabled());
        model.put("supportsRemoveAllRememberMecookies", this.hostApp.supportsRemoveAllRememberMeTokens());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/rememberme-cookies.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getParameter("removeAll") != null && this.hostApp.supportsRemoveAllRememberMeTokens()) {
            this.hostApp.removeAllRememberMeTokens();
        }
        if (req.getParameter("save-rememberme-cookies-setup") != null) {
            this.kerbConfManager.setRemembermeCookieEnabled("on".equals(req.getParameter("remembermeCookieEnabled")));
        }
        resp.sendRedirect("rememberme-cookies");
    }
}

