/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

@Scanned
public class MaxHeaderSizeAction
extends RequireAdminServlet {
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public MaxHeaderSizeAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        resp.setContentType("text/html");
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("applicationVersion", this.applicationProperties.getVersion());
        model.put("localPort", req.getLocalPort());
        model.put("isTomcat", this.isServerInfo(req, "tomcat"));
        model.put("isJetty", this.isServerInfo(req, "jetty"));
        this.determineAJP(req, model);
        this.renderer.render("templates/atlaskerb/maxheadersize.vm", model, (Writer)resp.getWriter());
    }

    private boolean determineAJP(HttpServletRequest req, Map<String, Object> model) {
        HttpServletRequest unwrapped = req;
        while (unwrapped instanceof HttpServletRequestWrapper) {
            unwrapped = (HttpServletRequest)((HttpServletRequestWrapper)unwrapped).getRequest();
        }
        if (unwrapped.getClass().getSimpleName().equals("RequestFacade")) {
            try {
                Field requestField = unwrapped.getClass().getDeclaredField("request");
                requestField.setAccessible(true);
                Object request = requestField.get(unwrapped);
                Field connectorField = request.getClass().getDeclaredField("connector");
                connectorField.setAccessible(true);
                Object connector = connectorField.get(request);
                Method protocolMethod = connector.getClass().getDeclaredMethod("getProtocol", new Class[0]);
                protocolMethod.setAccessible(true);
                String protocol = (String)protocolMethod.invoke(connector, new Object[0]);
                model.put("protocol", protocol);
                if (protocol != null && protocol.toLowerCase().contains("ajp")) {
                    model.put("isAJP", true);
                }
                Method portMethod = connector.getClass().getMethod("getPort", new Class[0]);
                Integer port = (Integer)portMethod.invoke(connector, new Object[0]);
                model.put("connectorPort", port);
            }
            catch (NoSuchFieldException e) {
                return false;
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
        }
        return false;
    }

    private boolean isServerInfo(HttpServletRequest req, String tomcat) {
        return req.getServletContext().getServerInfo().toLowerCase().contains(tomcat);
    }
}

