/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import org.kantega.atlaskerb.apiserver.ApiServerConfigJobRunner;
import org.kantega.atlaskerb.saml.cert.UpdateCertMetadataJobRunner;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class JobManager
implements InitializingBean,
DisposableBean {
    private final SchedulerService schedulerService;
    private final ApiServerConfigJobRunner apiServerConfigJobRunner;
    private final UpdateCertMetadataJobRunner updateCertMetadataJobRunner;
    private final List<JobId> scheduledJobIds = new CopyOnWriteArrayList<JobId>();
    private final List<JobRunnerKey> registeredJobRunnerKeys = new CopyOnWriteArrayList<JobRunnerKey>();

    @Inject
    public JobManager(ApiServerConfigJobRunner apiServerConfigJobRunner, UpdateCertMetadataJobRunner updateCertMetadataJobRunner) {
        this.schedulerService = (SchedulerService)ComponentLocator.getComponent(SchedulerService.class);
        this.apiServerConfigJobRunner = apiServerConfigJobRunner;
        this.updateCertMetadataJobRunner = updateCertMetadataJobRunner;
    }

    public void afterPropertiesSet() {
        this.scheduleApiServerConfigJob();
        this.scheduleSamlCertMetadataJob();
    }

    private void scheduleApiServerConfigJob() {
        JobRunnerKey jobRunnerKey = ApiServerConfigJobRunner.JOB_RUNNER_KEY;
        Schedule schedule2 = Schedule.forInterval((long)120000L, (Date)new Date(System.currentTimeMillis() + 20000L));
        this.scheduleJob(jobRunnerKey, schedule2, this.apiServerConfigJobRunner);
    }

    private void scheduleSamlCertMetadataJob() {
        long twentyFourHoursInMillis = 86400000L;
        Schedule schedule2 = Schedule.forInterval((long)twentyFourHoursInMillis, (Date)new Date(System.currentTimeMillis() + 20000L));
        this.scheduleJob(UpdateCertMetadataJobRunner.JOB_RUNNER_KEY, schedule2, this.updateCertMetadataJobRunner);
    }

    private void scheduleJob(JobRunnerKey jobRunnerKey, Schedule schedule2, JobRunner runner) {
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withSchedule(schedule2).withRunMode(RunMode.RUN_LOCALLY);
        this.schedulerService.registerJobRunner(jobRunnerKey, runner);
        this.registeredJobRunnerKeys.add(jobRunnerKey);
        try {
            this.scheduledJobIds.add(this.schedulerService.scheduleJobWithGeneratedId(jobConfig));
        }
        catch (SchedulerServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() throws Exception {
        for (JobId scheduledJobId : this.scheduledJobIds) {
            this.schedulerService.unscheduleJob(scheduledJobId);
        }
        for (JobRunnerKey registeredJobRunnerKey : this.registeredJobRunnerKeys) {
            this.schedulerService.unregisterJobRunner(registeredJobRunnerKey);
        }
    }
}

