/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.collection.List;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;
import org.kantega.atlaskerb.DebugInfo;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.scim.ScimConfManager;

public class DebugInfoServlet
extends RequireAdminServlet {
    final ConnectorConfManager connectorConfManager;
    final HostApp hostApp;
    final IdpConfManager idpConfManager;
    final KerbConfManager kerbConfManager;
    final ScimConfManager scimConfManager;
    final TemplateRenderer templateRenderer;
    final UserLookupService userLookupService;

    @Inject
    public DebugInfoServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.connectorConfManager = bucket.getConnectorConfManager();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.idpConfManager = bucket.getIdpConfManager();
        this.kerbConfManager = bucket.getKerbConfManager();
        this.scimConfManager = bucket.getScimConfManager();
        this.templateRenderer = bucket.getTemplateRenderer();
        this.userLookupService = bucket.getUserLookupService();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        JSONObject debugInfo = new JSONObject();
        debugInfo.put("connectorConfManager", Try.of(() -> this.connectorConfManager).map(ConnectorConfManager::asJson).getOrElse(new JSONObject()));
        debugInfo.put("scimConfManager", Try.of(() -> this.scimConfManager).mapTry(ScimConfManager::asJson).getOrElse(new JSONObject()));
        debugInfo.put("idpConfManager", Try.of(() -> this.idpConfManager).mapTry(IdpConfManager::asJson).getOrElse(new JSONObject()));
        debugInfo.put("idpConfigs", List.ofAll(this.idpConfManager.getIdentityProviders()).map(IdpConfiguration::asJson).toJavaList());
        debugInfo.put("hostApp", Try.of(() -> this.hostApp).mapTry(DebugInfo::asJson).getOrElse(new JSONObject()));
        debugInfo.put("kerbConfManager", Try.of(() -> this.kerbConfManager).mapTry(KerbConfManager::asJson).getOrElse(new JSONObject()));
        debugInfo.put("userLookupService", Try.of(() -> this.userLookupService).mapTry(UserLookupService::asJson).getOrElse(new JSONObject()));
        resp.setContentType("text/html");
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "support");
        model.put("menuItem", "debuginfo");
        model.put("highlightjs", PluginKey.getPluginKey() + ":highlightjs");
        model.put("debugInfo", debugInfo.toString(4));
        this.templateRenderer.render("templates/debuginfo.vm", model, (Writer)resp.getWriter());
    }
}

