/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.ksso.scim.ScimProviderKind;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;

@Scanned
public class DashboardAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;

    @Inject
    public DashboardAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean isCloudConnectorsConfigred;
        resp.setContentType("text/html");
        Map<String, Object> model = this.newModel(req);
        this.idpConfManager.readState();
        this.connectorConfManager.readState();
        model.put("topMenu", "dashboard");
        model.put("menuItem", "dashboard");
        model.put("applicationProperties", this.applicationProperties);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("providerKinds", IdpConfiguration.Kind.values());
        model.put("connectorTypes", this.connectorConfManager.getConnectorTypes());
        model.put("scimTenantConfigKinds", Arrays.asList(ScimProviderKind.values()));
        boolean isSamlConfigured = !this.idpConfManager.getIdentityProviders().isEmpty() || !this.idpConfManager.getProviderDrafts().isEmpty();
        boolean isKerberosConfigured = this.kerbConfManager.isKeytabConfigured();
        boolean bl = isCloudConnectorsConfigred = !this.connectorConfManager.getDirectories().isEmpty();
        if (!isSamlConfigured && !isKerberosConfigured && !isCloudConnectorsConfigred && this.kerbConfManager.showWelcomeMessage()) {
            resp.sendRedirect("onboard");
        }
        Properties buildInfo = KerbConfManager.getBuildInfo();
        model.put("version", buildInfo.getProperty("build.version"));
        model.put("buildDate", buildInfo.getProperty("build.date"));
        String kssoBuildPipelineId = buildInfo.getProperty("ksso.build.pipeline.id");
        String kssoBuildPipelineUrl = buildInfo.getProperty("ksso.build.pipeline.url");
        model.put("kssoBuildPipelineId", StringUtils.isNotBlank(kssoBuildPipelineId) ? kssoBuildPipelineId : null);
        model.put("kssoBuildPipelineUrl", StringUtils.isNotBlank(kssoBuildPipelineUrl) ? kssoBuildPipelineUrl : null);
        try {
            this.checkNonstandardSeraphAuthenticator(model);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkSigningKeyPassword(model);
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            model.put("license", this.pluginLicenseManager.getLicense().get());
        }
        this.templateRenderer.render("templates/atlaskerb/dashboard.vm", model, (Writer)resp.getWriter());
    }

    private void checkSigningKeyPassword(Map<String, Object> model) {
        model.put("invalidSigningKeyPassword", this.idpConfManager.isActiveSigningKeyDefined() && this.idpConfManager.getSpSigningCredential().getPrivateKey() == null);
    }

    private void checkNonstandardSeraphAuthenticator(Map<String, Object> model) {
        String nonStandardAuthenticator = this.hostApp.hasNonStandardAuthenticator();
        if (nonStandardAuthenticator != null) {
            model.put("nonStandardSeraphAuthenticator", nonStandardAuthenticator);
            model.put("standardSeraphAuthenticator", this.hostApp.getStandardAuthenticatorClassName());
        }
    }
}

