/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.saml.IdpConfManager;

@Scanned
public class CustomizableTextsAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;
    private final IdpConfManager idpConfManager;

    public CustomizableTextsAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostAppFactory().getInstance();
        this.idpConfManager = bucket.getIdpConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "customizable-texts");
        model.put("errorPageMessage", this.kerbConfManager.getErrorPageMessage());
        model.put("samlLoginUsernamePlaceholder", this.kerbConfManager.getSamlLoginUsernamePlaceholder());
        model.put("usernameFieldText", this.kerbConfManager.getUsernameFieldText());
        model.put("nextButtonText", this.kerbConfManager.getNextButtonText());
        model.put("idpListTitleText", this.kerbConfManager.getIdpListTitleText());
        model.put("defaultSamlLoginUsernamePlaceholder", this.kerbConfManager.getDefaultSamlLoginUsernamePlaceholder());
        model.put("defaultErrorPageMessage", this.kerbConfManager.getDefaultErrorPageMessage());
        model.put("defaultUsernameFieldText", this.kerbConfManager.getDefaultUsernameFieldText());
        model.put("defaultNextButtonText", this.kerbConfManager.getDefaultNextButtonText());
        model.put("defaultIdpListTitleText", this.kerbConfManager.getDefaultIdpListTitleText());
        model.put("samlEnabled", this.idpConfManager.isSamlEnabled());
        model.put("traditionalLoginDisabledMessage", this.kerbConfManager.getTraditionalLoginDisabledMessage());
        model.put("defaultTraditionalLoginDisabledMessage", this.kerbConfManager.getTraditionalLoginDisabledDefaultMessage());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/customizableTexts.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String errorMessage = req.getParameter("errorMessage");
        String samlLoginUsernamePlaceholder = req.getParameter("samlLoginUsernamePlaceholder");
        String usernameFieldText = req.getParameter("usernameFieldText");
        String nextButtonText = req.getParameter("nextButtonText");
        String idpListTitleText = req.getParameter("idpListTitleText");
        this.kerbConfManager.setErrorPageMessage(errorMessage);
        this.kerbConfManager.setSamlLoginUsernamePlaceholder(samlLoginUsernamePlaceholder);
        this.kerbConfManager.setUsernameFieldText(usernameFieldText);
        this.kerbConfManager.setNextButtonText(nextButtonText);
        this.kerbConfManager.setIdpListTitleText(idpListTitleText);
        String traditionalLoginDisabledMessage = req.getParameter("traditionalLoginDisabledMessage");
        this.kerbConfManager.setTraditionalLoginDisabledMessage(StringUtils.isBlank(traditionalLoginDisabledMessage) ? this.kerbConfManager.getTraditionalLoginDisabledDefaultMessage() : traditionalLoginDisabledMessage);
        resp.sendRedirect("customizable-texts");
    }
}

