/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

@Scanned
public class ConfigureWebdavAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;

    @Inject
    public ConfigureWebdavAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("webdavEnabled", this.kerbConfManager.isWebdavEnabled());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/webdav.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getParameter("enable") != null) {
            this.kerbConfManager.setWebdavEnabled(true);
        } else if (req.getParameter("disable") != null) {
            this.kerbConfManager.setWebdavEnabled(false);
        }
        resp.sendRedirect("config");
    }
}

