/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;

@Scanned
public class ConfigureRestAction
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;

    @Inject
    public ConfigureRestAction(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("restEnabled", this.kerbConfManager.isRestAuthEnabled());
        String actualUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        model.put("actualBaseUrl", actualUrl);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("excludedPaths", StringUtils.join(this.kerbConfManager.getRestExcludedPaths(), "\n"));
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/restapi.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean restAuthEnabled = StringUtils.equalsIgnoreCase("on", req.getParameter("rest_auth"));
        String excludedPathsStr = req.getParameter("excludedPaths");
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        if (excludedPathsStr != null && !excludedPathsStr.isEmpty()) {
            String[] lines = excludedPathsStr.split("\\r?\\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i].trim().replace(",", "");
                if (StringUtils.isBlank(line)) continue;
                paths.add(line);
            }
        }
        this.kerbConfManager.setRestExcludedPaths(paths);
        if (restAuthEnabled) {
            this.kerbConfManager.setRestAuthEnabled(true);
        } else {
            this.kerbConfManager.setRestAuthEnabled(false);
        }
        resp.sendRedirect("restapi");
    }
}

