/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.AtlDirectoryManager;
import org.kantega.atlaskerb.FetchKeysAction;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.KeytabUploadData;
import org.kantega.atlaskerb.LdapPrincipalSearcher;
import org.kantega.atlaskerb.MultipartHttpRequest;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.keytab.Keytab;
import org.kantega.atlaskerb.keytab.KeytabEntry;
import org.simplericity.serberuhs.keytab.KeytabInfo;
import org.simplericity.serberuhs.keytab.KeytabParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class ConfigureKeytabAction
extends RequireAdminServlet {
    private final LdapPrincipalSearcher ldapPrincipalSearcher;
    private final AtlDirectoryManager directoryManager;
    private final KerbConfManager kerbConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final Logger log = LoggerFactory.getLogger(ConfigureKeytabAction.class);

    @Inject
    public ConfigureKeytabAction(RequireAdminServletDependencyBucket bucket, LdapPrincipalSearcher ldapPrincipalSearcher, AtlDirectoryManager directoryManager) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.ldapPrincipalSearcher = ldapPrincipalSearcher;
        this.directoryManager = directoryManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        this.render(req, resp, model);
    }

    private void render(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> model) throws IOException {
        resp.setContentType("text/html");
        model.put("fetchSources", Collections.emptyList());
        model.put("purge", req.getParameter("purge") != null);
        File file = this.kerbConfManager.getKeytabFile();
        boolean keytabConfigured = this.kerbConfManager.isKeytabConfigured();
        boolean uploaded = this.kerbConfManager.isKeytabUploaded();
        String keytabFile = uploaded || file == null ? null : file.getAbsolutePath();
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("wizard", req.getParameter("wizard") != null);
        model.put("keytabFile", keytabFile);
        model.put("keytabConfigured", keytabConfigured);
        model.put("existingUploadedKeys", uploaded && keytabConfigured);
        model.put("productName", this.kerbConfManager.getApplicationProperties().getDisplayName());
        model.put("userDirectories", FetchKeysAction.guessServiceAccounts(req, this.directoryManager, this.newModel(req), this.ldapPrincipalSearcher, this.directoryManager.getActiveMsAdDirectories()));
        if (keytabConfigured) {
            org.kantega.atlaskerb.Keytab keytab = new org.kantega.atlaskerb.Keytab(this.kerbConfManager.getKeytabInfos());
            model.put("keytab", keytab);
        }
        this.renderer.render("templates/atlaskerb/keytab.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected boolean expectsMultipart() {
        return true;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        InputStream toValidate;
        String error;
        KeytabUploadData uploadedKeytab;
        boolean existedBeforeUpload = this.kerbConfManager.isKeytabConfigured();
        MultipartHttpRequest multipartRequest = this.getMultipartRequest(req, 100000L);
        String removeKey = multipartRequest.getParameter("remove-key-entry");
        if (removeKey != null && this.kerbConfManager.isKeytabUploaded()) {
            Keytab keytab = new Keytab();
            List<KeytabEntry> existingEntries = keytab.read(this.kerbConfManager.getKeytabFile());
            ArrayList<KeytabEntry> keep = new ArrayList<KeytabEntry>();
            for (KeytabEntry existingEntry : existingEntries) {
                if (removeKey.equals(existingEntry.getEntryKey())) continue;
                keep.add(existingEntry);
            }
            if (keep.size() != existingEntries.size()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                keytab.write(keep, out);
                this.kerbConfManager.setKeytabContent(out.toByteArray());
            }
            resp.sendRedirect("keytab");
        }
        if ((uploadedKeytab = this.getKeytabUploadData(multipartRequest)).getErrorMessage() != null) {
            this.renderError(req, resp, uploadedKeytab.getErrorMessage());
            return;
        }
        if (uploadedKeytab.getBytes() == null && uploadedKeytab.getPath() == null) {
            this.renderError(req, resp, "No keytab data in request");
            return;
        }
        if (uploadedKeytab.getPath() != null) {
            File keytabFile = new File(uploadedKeytab.getPath());
            if (!keytabFile.exists()) {
                this.renderError(req, resp, "The specified file could not be found");
                return;
            }
            if (!keytabFile.canRead()) {
                this.renderError(req, resp, this.applicationProperties.getDisplayName() + " does not have file permissions to read " + keytabFile.getAbsolutePath());
                return;
            }
        }
        if ((error = this.validateKeytab(toValidate = uploadedKeytab.getBytes() != null ? new ByteArrayInputStream(uploadedKeytab.getBytes()) : new FileInputStream(uploadedKeytab.getPath()))) != null) {
            this.renderError(req, resp, error);
            return;
        }
        if (uploadedKeytab.getBytes() != null) {
            if ("merge".equals(multipartRequest.getParameter("replace_or_merge")) && this.kerbConfManager.isKeytabUploaded()) {
                File existingFile = this.kerbConfManager.getKeytabFile();
                try {
                    Keytab keytab = new Keytab();
                    HashSet<String> keys2 = new HashSet<String>();
                    List<KeytabEntry> existingEntries = keytab.read(existingFile);
                    for (KeytabEntry existingEntry : existingEntries) {
                        keys2.add(existingEntry.getEntryKey());
                    }
                    List<KeytabEntry> newEntries = keytab.read(new ByteArrayInputStream(uploadedKeytab.getBytes()));
                    ArrayList<KeytabEntry> merged = new ArrayList<KeytabEntry>();
                    for (KeytabEntry newEntry : newEntries) {
                        if (keys2.contains(newEntry.getEntryKey())) continue;
                        merged.add(newEntry);
                    }
                    merged.addAll(existingEntries);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    keytab.write(merged, out);
                    this.kerbConfManager.setKeytabContent(out.toByteArray());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.kerbConfManager.setKeytabContent(uploadedKeytab.getBytes());
            }
        } else if (uploadedKeytab.getPath() != null) {
            this.kerbConfManager.setKeytabFile(new File(uploadedKeytab.getPath()));
        }
        this.kerbConfManager.flushKeytabCaches();
        String configUrl = "test?keytab";
        if (existedBeforeUpload) {
            configUrl = "keytab?purge";
        }
        resp.sendRedirect(configUrl);
    }

    public KeytabUploadData getKeytabUploadData(MultipartHttpRequest req) {
        byte[] file = req.getFile("file");
        if (file != null) {
            return new KeytabUploadData(file, null, null);
        }
        String path = req.getParameter("path");
        if (path != null) {
            path = path.trim();
            return new KeytabUploadData(null, path, null);
        }
        return new KeytabUploadData(null, path, "Missing keytab file path in request");
    }

    private void renderError(HttpServletRequest req, HttpServletResponse resp, String error) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("error", error);
        this.render(req, resp, model);
    }

    private String validateKeytab(InputStream is) {
        List<KeytabInfo> infos;
        try {
            infos = new KeytabParser().parse(is);
        }
        catch (Exception e) {
            this.log.error("Exception parsing keytab file", (Throwable)e);
            return "Exception parsing keytab file. Are you sure this is a valid keytab file?";
        }
        if (infos.size() == 0) {
            return "Keytab must have at least one entry";
        }
        ArrayList<KeytabInfo> httpInfos = new ArrayList<KeytabInfo>();
        TreeSet<String> spns = new TreeSet<String>();
        org.kantega.atlaskerb.Keytab keytab = new org.kantega.atlaskerb.Keytab(Collections.emptyList());
        for (KeytabInfo info : infos) {
            spns.add(keytab.nameOf(info));
            if (!info.getServicePart().equals("HTTP") && !info.getServicePart().equals("http")) continue;
            httpInfos.add(info);
        }
        if (httpInfos.isEmpty()) {
            return "At least one Service Principal Name in the keytab must start with 'HTTP/'. Found only: " + spns;
        }
        return null;
    }
}

