/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.ExceptionTool;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.diagnostics.FailureListener;

@Scanned
public class ClientFailureServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final FailureListener failureListener;
    private final TemplateRenderer renderer;

    @Inject
    public ClientFailureServlet(RequireAdminServletDependencyBucket bucket, FailureListener failureListener) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.failureListener = failureListener;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("failures", this.failureListener.failures());
        model.put("exceptionTool", new ExceptionTool());
        model.put("dateTool", new DateTool());
        model.put("enabled", this.kerbConfManager.isClientFailureCollectionEnabled());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/failures.vm", model, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getParameter("enable") != null) {
            this.kerbConfManager.setClientFailureCollectionEnabled(true);
        } else if (req.getParameter("disable") != null) {
            this.kerbConfManager.setClientFailureCollectionEnabled(false);
        }
        resp.sendRedirect("failures");
    }
}

