/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.kantega.atlaskerb.IpRestrictionConfig;
import org.kantega.atlaskerb.IpRestrictionFilter;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.LoginAttempt;
import org.kantega.atlaskerb.ManualLoginEvent;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.PrincipalEntry;
import org.kantega.atlaskerb.UserLookupService;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.diagnostics.AuditLogFacade;
import org.kantega.atlaskerb.diagnostics.FailureListener;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.restapi.access.RestrictAPIEndpoint;
import org.kantega.atlaskerb.restapi.access.TokenEndpointService;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SSOScriptLoginHookCondition;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.simplericity.serberuhs.DecodedKerberosToken;
import org.simplericity.serberuhs.SpNego;
import org.simplericity.serberuhs.SpNegoResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class AtlasKerberosFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AtlasKerberosFilter.class);
    private static final Logger manualLoginLog = LoggerFactory.getLogger(ManualLoginEvent.class);
    public static final String LOCKOUT_TIMESTAMP = "lockout_timestamp";
    public static final String USERNAME_ANONYMOUS_USER = "usernameAnonymousUser";
    private final KerbConfManager kerbConfManager;
    private final FailureListener failureListener;
    private final AuditLogFacade auditLogFacade;
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;
    private final SSOScriptLoginHookCondition loginScriptCondition;
    private final ApiTokenService apiTokenService;
    private final TokenEndpointService tokenEndpointService;
    private final UserManager userManager;
    private final UserLookupService userLookupService;
    private final WebResourceManager webResourceManager;
    private String[] products;
    private static final String ALREADY_MATCHED_ATTR = AtlasKerberosFilter.class.getName() + "_alreadyMatched";

    @Inject
    public AtlasKerberosFilter(@ComponentImport HttpContext httpContext, @ComponentImport WebResourceManager webResourceManager, @ComponentImport UserManager userManager, ApiTokenService apiTokenService, TokenEndpointService tokenEndpointService, KerbConfManager kerbConfManager, FailureListener failureListener, AuditLogFacade auditLogFacade, UserLookupService userLookupService, HostAppFactory hostAppFactory, IdpConfManager idpConfManager) {
        this.kerbConfManager = kerbConfManager;
        this.apiTokenService = apiTokenService;
        this.tokenEndpointService = tokenEndpointService;
        this.userManager = userManager;
        this.failureListener = failureListener;
        this.auditLogFacade = auditLogFacade;
        this.userLookupService = userLookupService;
        this.webResourceManager = webResourceManager;
        this.hostApp = hostAppFactory.getInstance();
        this.idpConfManager = idpConfManager;
        this.loginScriptCondition = new SSOScriptLoginHookCondition(httpContext, hostAppFactory, idpConfManager);
    }

    public void init(FilterConfig filterConfig) {
        String productsParam = filterConfig.getInitParameter("products");
        if (productsParam != null) {
            this.products = productsParam.split(",");
            for (int i = 0; i < this.products.length; ++i) {
                this.products[i] = this.products[i].trim().toLowerCase();
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        boolean alreadyMatched = req.getAttribute(ALREADY_MATCHED_ATTR) != null;
        this.setNokerberosSession(req);
        if (alreadyMatched && !this.isForwarded(req) || !this.isProductMatch()) {
            chain.doFilter(request, response);
            return;
        }
        req.setAttribute(ALREADY_MATCHED_ATTR, (Object)true);
        String requestURI = req.getRequestURI();
        boolean isLoginPage = this.hostApp.isPageWithLoginForm(req, requestURI.substring(req.getContextPath().length()));
        if (isLoginPage && this.kerbConfManager.isTraditionalLoginDisabled() && this.userLookupService.getDirectoriesAllowingTraditionalLogin().size() == 0 && this.kerbConfManager.getAllowTraditionalLoginGroups().size() == 0 && this.kerbConfManager.getDisallowTraditionalLoginGroups().size() == 0 && !this.isForceUIForTest(req)) {
            log.debug("Including disabling-login elements in page since traditional login is disabled for {}", (Object)requestURI);
            this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":disable-login");
        }
        String internalPath = HttpUrlUtils.getInternalPath(req);
        boolean isRestApiRestrictedToApiTokens = this.kerbConfManager.isRestApiRestrictedToApiTokens();
        if (this.hostApp.isRestApi(internalPath) && isRestApiRestrictedToApiTokens) {
            boolean shouldBlockRequest;
            String sanitizedInternalPath = HttpUrlUtils.sanitizeUrlForTrailingSlashes(internalPath);
            List<RestrictAPIEndpoint> restrictAPIEndpoints = this.tokenEndpointService.findAllRestApiTokenEndpoints();
            boolean urlIsApiTokenRestricted = restrictAPIEndpoints.stream().anyMatch(endpoint -> Try.of(() -> endpoint).mapTry(RestrictAPIEndpoint::getInternalPathRest).mapTry(sanitizedInternalPath::startsWith).getOrElse(false));
            boolean isExternalCall = !this.hostApp.isRequestFromHostApp(req) && !this.hostApp.isRestPathInternalAtlassianFunctionality(req) && !this.hostApp.isJiraCrowdRequest(req);
            boolean bl = shouldBlockRequest = urlIsApiTokenRestricted && !this.apiTokenService.requestHasApiToken(req) && (isExternalCall || this.kerbConfManager.isRestApiCompleteLockdown());
            if (shouldBlockRequest) {
                String blockedMessage = Option.of(this.kerbConfManager.getLockedRestApiErrorPageMessage()).getOrElse(this.kerbConfManager.getDefaultLockedRestApiErrorPageMessage(req.getRequestURI()));
                res.sendError(403, blockedMessage);
                String username = HttpUrlUtils.credentialsWithBasicAuthSingleHeader(req).map(usernameAndPassword -> (String)usernameAndPassword._1()).getOrElse("<unknown>");
                this.auditLogFacade.loginFailed(username, "REST API Basic Auth", "REST API access is restricted to API Token authentication only.");
                log.debug(blockedMessage);
                return;
            }
        }
        if (this.idpConfManager.isAuthenticatedAnonymousBrowsingSessionActive(req)) {
            HttpSession session = req.getSession(false);
            String sessionUser = Option.of(session.getAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_USER")).map(String.class::cast).getOrElse("<anonymous>");
            String idpId = Option.of(session.getAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_SESSION_IDP_ID")).map(String.class::cast).getOrElse("");
            IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(idpId);
            if (this.hostApp.isMainLoginPage(requestURI)) {
                log.debug("Invalidating session of authenticated anonymous browsing session for user: {} ", (Object)sessionUser);
                session.invalidate();
            } else if (configuration.isAuthenticatedAnonymousBrowsingEnabled()) {
                log.debug("Authenticated anonymous browsing session is enabled and user: {} has an active session. Aborting login.", (Object)sessionUser);
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
                return;
            }
        }
        if (!this.isMappedRequest(req)) {
            log.trace("Request for {} is not mapped", (Object)requestURI);
            chain.doFilter(request, response);
            return;
        }
        if (this.isForwarded(req)) {
            log.debug("Initiating SSO on forwarded request from; {} to: {}", req.getAttribute("javax.servlet.forward.request_uri"), (Object)req.getRequestURI());
        }
        log.debug("KerberosFilter processing requestUri {}", (Object)requestURI);
        if (this.loginScriptCondition.shouldAddLoginScripts(req)) {
            this.webResourceManager.requireResource(PluginKey.getPluginKey() + ":saml-login");
        }
        if (this.hostApp.isLoggedIn(req)) {
            log.debug("isLoggedIn(req) -> doFilter");
            if (this.hostApp.shouldTryApiTokenAuthentication(req) && this.apiTokenService.requestHasApiToken(req)) {
                chain.doFilter((ServletRequest)this.removeAuthHeader(req), (ServletResponse)res);
                log.debug("Request has API token. Avoid attempting normal login");
                return;
            }
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        PluginLicense pluginLicense = null;
        try {
            if (this.kerbConfManager.getLicenseManager().getLicense().isDefined()) {
                pluginLicense = (PluginLicense)this.kerbConfManager.getLicenseManager().getLicense().get();
            }
        }
        catch (Exception e) {
            log.error("Exception getting Kerberos plugin configuration", (Throwable)e);
            chain.doFilter(request, response);
            return;
        }
        if (pluginLicense == null) {
            chain.doFilter(request, response);
            return;
        }
        if (!pluginLicense.isValid()) {
            log.info("License is not valid" + ((LicenseError)pluginLicense.getError().get()).name());
            chain.doFilter(request, response);
            return;
        }
        String usernameFromHeader = this.getUsernameFromHeader(req);
        if (usernameFromHeader != null) {
            try {
                PrincipalEntry principalEntry = this.userLookupService.resolveUserInDirectories(usernameFromHeader, true);
                if (principalEntry.getPrincipal().isPresent()) {
                    Principal principal2 = principalEntry.getPrincipal().get();
                    this.hostApp.publishUserAuthenticatedEvent(principal2);
                    this.authenticateWithProduct(req, res, principal2);
                    this.auditLogFacade.loginSuccess(principal2.getName(), "HeaderUsername");
                    chain.doFilter((ServletRequest)req, (ServletResponse)res);
                    return;
                }
                this.auditLogFacade.loginFailed(null, "HeaderUsername", "Could not find username " + usernameFromHeader + " in any directory. Trying other mechanisms to log in user.");
            }
            catch (Exception e) {
                this.auditLogFacade.loginFailed(null, "HeaderUsername", "Failed looking up " + usernameFromHeader + ". Trying other mechanisms to log in user.");
            }
        }
        if (this.hostApp.shouldTryApiTokenAuthentication(req) && this.apiTokenService.requestHasApiToken(req)) {
            Validation<String, UserProfile> validation = this.apiTokenService.verifyApiToken(req);
            if (validation.isValid()) {
                UserProfile userProfile = validation.get();
                String username = userProfile.getUsername();
                Option<PrincipalEntry> principalEntry = Option.of(this.userLookupService.lookupUser(username, false));
                if (principalEntry.isDefined() && principalEntry.get().getUserState() == PrincipalEntry.UserState.FOUND) {
                    principalEntry.get().getPrincipal().ifPresent(principal -> this.authenticateWithProduct(req, res, (Principal)principal));
                    chain.doFilter((ServletRequest)this.removeAuthHeader(req), (ServletResponse)res);
                    return;
                }
            } else if (this.apiTokenService.requestHasApiToken(req) && validation.isInvalid()) {
                res.sendError(401, "API Token not valid.");
                return;
            }
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        if (this.hostApp.isAuthTokenRequest(req)) {
            log.debug("Not processing request because it already has auth tokens");
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        if (this.hostApp.isLoginRequest(req)) {
            if (this.kerbConfManager.isManualLoginLogEnabled()) {
                String username = this.hostApp.getLoginRequestUsername(req);
                manualLoginLog.warn("Username/password login attempt recorded: ip: " + this.kerbConfManager.getRemoteIpAddress(req) + ", username: " + username + ", userAgent: " + req.getHeader("User-Agent"));
            }
            log.debug("isLoginRequest(req) -> doFilter");
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        if (this.shouldDoKerberos(req, res)) {
            DecodedKerberosToken decodedKerberosToken;
            String atz = req.getHeader("Authorization");
            if (atz == null || !atz.startsWith("Negotiate ")) {
                this.kerbConfManager.getStats().attempt();
                res.setStatus(401);
                res.setHeader("WWW-Authenticate", "Negotiate");
                log.debug(" Sending WWW-Authenticate header to IP: " + req.getRemoteAddr() + ", X-forwarded-for: " + req.getHeader("x-forwarded-for") + ", UserAgent: " + req.getHeader("User-Agent"));
                this.dispatchToLogin(req, res, chain);
                return;
            }
            SpNego spNego = new SpNego();
            try {
                decodedKerberosToken = this.kerbConfManager.decodeKerberosToken(req);
            }
            catch (Exception e) {
                if (e instanceof SpNego.NtlmTokenException) {
                    this.kerbConfManager.getStats().wrongTokenNtlm();
                    log.info("Negotiate token is an NTLM token from client " + AtlasKerberosFilter.getRemoteIp(req));
                    this.failureListener.failed(LoginAttempt.attempt("Client sent SPNego token with wrapped NTLM token.", AtlasKerberosFilter.getRemoteIp(req)).token(atz).exception(e), req.getRequestURI());
                } else if (e instanceof SpNego.DirectNtlmTokenException) {
                    this.kerbConfManager.getStats().wrongTokenNtlm();
                    log.info("Client sent an NTLM token from client " + AtlasKerberosFilter.getRemoteIp(req));
                    this.failureListener.failed(LoginAttempt.attempt("Client sent an NTLM token instead of Kerberos/SPNEGO", AtlasKerberosFilter.getRemoteIp(req)).token(atz).exception(e), req.getRequestURI());
                } else if (e instanceof SpNego.NoKerberosMechException) {
                    this.kerbConfManager.getStats().wrongTokenNotKerberos();
                    log.info("Negotiate token does not have any Kerberos tokens from client " + AtlasKerberosFilter.getRemoteIp(req));
                    this.failureListener.failed(LoginAttempt.attempt("Client sent an SPNEGO token wrapping a non-Kerberos token", AtlasKerberosFilter.getRemoteIp(req)).token(atz).exception(e), req.getRequestURI());
                } else {
                    this.failureListener.failed(LoginAttempt.attempt("Failed to parse the client token", AtlasKerberosFilter.getRemoteIp(req)).token(atz).exception(e), req.getRequestURI());
                    this.kerbConfManager.getStats().failedDecodingToken();
                    log.error("Exception decoding SPNEGO token from client " + AtlasKerberosFilter.getRemoteIp(req), (Throwable)e);
                }
                res.setStatus(401);
                log.debug("shouldDoKerberos() -> dispatchToLogin");
                this.dispatchToLogin(req, res, chain);
                return;
            }
            try {
                Subject subject = this.kerbConfManager.getSubject(decodedKerberosToken);
                spNego.negotiate(subject, req, res);
            }
            catch (Throwable e) {
                log.error("Unexpected error negotiating SPNEGO token", e);
                this.auditLogFacade.loginFailed(null, "Kerberos", "Unexpected error negotiating SPNEGO token.");
                chain.doFilter(request, response);
                return;
            }
            if (spNego.getResult() == SpNegoResult.AUTHORIZED) {
                PrincipalEntry principalEntry = this.userLookupService.lookupUser(spNego.getAuthorizedPrincipal(), true);
                if (!principalEntry.getPrincipal().isPresent()) {
                    this.failureListener.failed(LoginAttempt.attempt("User account not found", AtlasKerberosFilter.getRemoteIp(req)).token(atz).user(spNego.getAuthorizedPrincipal()), req.getRequestURI());
                    this.kerbConfManager.getStats().missingUser();
                    log.debug("Kerberos ticket OK -> User account not found");
                    this.auditLogFacade.loginFailed(spNego.getAuthorizedPrincipal(), "Kerberos", "User account not found.");
                    req.setAttribute(USERNAME_ANONYMOUS_USER, (Object)spNego.getAuthorizedPrincipal());
                    this.dispatchToLogin(req, res, chain);
                    return;
                }
                Principal principal3 = principalEntry.getPrincipal().get();
                this.hostApp.publishUserAuthenticatedEvent(principal3);
                if (principalEntry.getUserState() == PrincipalEntry.UserState.INACTIVE) {
                    this.failureListener.failed(LoginAttempt.attempt("User account is not active", AtlasKerberosFilter.getRemoteIp(req)).token(atz).user(principal3.getName()), req.getRequestURI());
                    this.kerbConfManager.getStats().lacksPermission();
                    log.debug("Kerberos ticket OK -> User account not active");
                    this.auditLogFacade.loginFailed(principal3.getName(), "Kerberos", "User account not active.");
                    this.dispatchToLogin(req, res, chain);
                    return;
                }
                if (!this.hostApp.isUserInRequiredGroups(principal3.getName())) {
                    this.failureListener.failed(LoginAttempt.attempt("User account lacks required group(s) " + StringUtils.join(this.kerbConfManager.getRequiredGroups(), ","), AtlasKerberosFilter.getRemoteIp(req)).token(atz).user(principal3.getName()), req.getRequestURI());
                    this.kerbConfManager.getStats().lacksRequiredGroup();
                    if (!this.kerbConfManager.isUserdetailsInCommentsEnabled()) {
                        this.refreshKerberosLockout(req);
                    }
                    log.debug("Kerberos ticket OK -> User account lacks required group(s)");
                    this.auditLogFacade.loginFailed(principal3.getName(), "Kerberos", "User account lacks required group(s).");
                    req.setAttribute(USERNAME_ANONYMOUS_USER, (Object)principal3.getName());
                    this.dispatchToLogin(req, res, chain);
                    return;
                }
                if (this.hostApp.shouldRequireCanLogin(req) && !this.hostApp.canLogin(principal3, req)) {
                    this.failureListener.failed(LoginAttempt.attempt("User account lacks login permission", AtlasKerberosFilter.getRemoteIp(req)).token(atz).user(principal3.getName()), req.getRequestURI());
                    this.kerbConfManager.getStats().lacksPermission();
                    log.debug("Kerberos ticket OK -> User accounts lacks canUse/canLogin");
                    this.auditLogFacade.loginFailed(principal3.getName(), "Kerberos", "User accounts lacks canUse/canLogin.");
                    req.setAttribute(USERNAME_ANONYMOUS_USER, (Object)principal3.getName());
                    this.dispatchToLogin(req, res, chain);
                    return;
                }
                if (this.kerbConfManager.isKerberosEnabled()) {
                    this.finishSuccessfulKerberosLogin(req, res, principal3, chain);
                } else {
                    ArrayList<Directory> dirsAllowing = new ArrayList();
                    try {
                        dirsAllowing = this.userLookupService.getDirectoriesAllowingKerberosLogin();
                    }
                    catch (RuntimeException e) {
                        log.warn("Not able to search for directories: " + e.getMessage());
                    }
                    if (this.userLookupService.userInAllowedDirectoryOrGroup(req, dirsAllowing, this.hostApp, this.kerbConfManager.getAllowKerberosLoginGroups(), this.kerbConfManager.getDisallowKerberosLoginGroups(), principal3.getName())) {
                        this.finishSuccessfulKerberosLogin(req, res, principal3, chain);
                    } else {
                        chain.doFilter((ServletRequest)req, (ServletResponse)res);
                    }
                }
            } else {
                if (spNego.getResult() == SpNegoResult.AUTHORIZATION_FAILED) {
                    this.failureListener.failed(LoginAttempt.attempt("Failed to validate client token", AtlasKerberosFilter.getRemoteIp(req)).token(atz).exception(spNego.getException()), req.getRequestURI());
                    this.auditLogFacade.loginFailed(null, "Kerberos", "Failed to validate client token.");
                    this.kerbConfManager.getStats().authFailed();
                } else if (spNego.getResult() == SpNegoResult.WRONG_TOKEN_BASIC) {
                    this.failureListener.failed(LoginAttempt.attempt("Client sent a Basic token", AtlasKerberosFilter.getRemoteIp(req)).token(atz), req.getRequestURI());
                    this.auditLogFacade.loginFailed(null, "Kerberos", "Client sent a Basic token.");
                    this.kerbConfManager.getStats().wrongTokenBasic();
                } else if (spNego.getResult() == SpNegoResult.WRONG_TOKEN_NTLM) {
                    this.failureListener.failed(LoginAttempt.attempt("Client sent an NTLM token", AtlasKerberosFilter.getRemoteIp(req)).token(atz), req.getRequestURI());
                    this.auditLogFacade.loginFailed(null, "Kerberos", "Client sent an NTLM token.");
                    this.kerbConfManager.getStats().wrongTokenNtlm();
                } else if (spNego.getResult() == SpNegoResult.WRONG_TOKEN_NOT_NEGOTIATE) {
                    this.failureListener.failed(LoginAttempt.attempt("Client sent a non-Negotiate token", AtlasKerberosFilter.getRemoteIp(req)).token(atz), req.getRequestURI());
                    this.auditLogFacade.loginFailed(null, "Kerberos", "Client sent a non-Negotiate token.");
                    this.kerbConfManager.getStats().wrongTokenNotNegotiate();
                } else if (spNego.getResult() == SpNegoResult.FAILED_PARSING_TOKEN) {
                    this.failureListener.failed(LoginAttempt.attempt("Failed parsing token", AtlasKerberosFilter.getRemoteIp(req)).token(atz), req.getRequestURI());
                    this.auditLogFacade.loginFailed(null, "Kerberos", "Failed parsing token.");
                    this.kerbConfManager.getStats().failedParsingToken();
                }
                res.setStatus(401);
                log.debug("Kerberos ticket INVALID -> dispatchToLogin fallback");
                this.dispatchToLogin(req, res, chain);
            }
        } else if (this.loginScriptCondition.shouldDoFederatedSSO(req)) {
            log.debug("shouldAddLoginScript() -> dispatchToLogin");
            this.dispatchToLogin(req, res, chain);
        } else {
            log.debug("Should not do Kerberos or SAML doFilter");
            chain.doFilter(request, response);
        }
    }

    private void finishSuccessfulKerberosLogin(HttpServletRequest req, HttpServletResponse res, Principal principal, FilterChain chain) throws ServletException, IOException {
        this.authenticateWithProduct(req, res, principal);
        this.kerbConfManager.getStats().success();
        res.setHeader("Persistent-Auth", "false");
        log.debug("Kerberos ticket OK -> login success");
        this.auditLogFacade.loginSuccess(principal.getName(), "Kerberos");
        this.hostApp.postSuccessfulLoginWithKerberosAction(principal, req, res, chain);
    }

    private boolean isForceUIForTest(HttpServletRequest req) {
        String qry = req.getQueryString();
        return qry != null && qry.contains("forceUIForTest");
    }

    private void refreshKerberosLockout(HttpServletRequest req) {
        req.getSession(true).setAttribute(LOCKOUT_TIMESTAMP, (Object)System.nanoTime());
    }

    private boolean querystringHas(String queryStringPart, HttpServletRequest req) {
        return StringUtils.contains((CharSequence)req.getQueryString(), queryStringPart);
    }

    private void setNokerberosSession(HttpServletRequest req) {
        if (this.querystringHas("nokerberosSession", req)) {
            req.getSession().setAttribute("nokerberosSession", (Object)true);
        } else if (this.querystringHas("kerberosSession", req)) {
            req.getSession().removeAttribute("nokerberosSession");
        }
    }

    private boolean shouldDoKerberos(HttpServletRequest req, HttpServletResponse res) {
        if (req.getSession().getAttribute("nokerberosSession") != null || this.querystringHas("nokerberos", req)) {
            return false;
        }
        if (!this.kerbConfManager.isKerberosEnabled() && this.userLookupService.getDirectoriesAllowingKerberosLogin().size() == 0 && this.kerbConfManager.getAllowKerberosLoginGroups().size() == 0 && this.kerbConfManager.getDisallowKerberosLoginGroups().size() == 0) {
            return false;
        }
        if (!this.kerbConfManager.isKeytabConfigured()) {
            return false;
        }
        if (!this.kerbConfManager.isUserAgentEnabled(req.getHeader("User-agent"))) {
            return false;
        }
        String internalPathOfReq = HttpUrlUtils.getInternalPath(req);
        String remoteIpAddress = this.kerbConfManager.getRemoteIpAddress(req);
        boolean isRestApi = this.hostApp.isRestApi(internalPathOfReq);
        IpRestrictionConfig ipRestrictionConfig = this.kerbConfManager.getIpRestrictionConfig();
        if (!isRestApi && !ipRestrictionConfig.globalIpFilter().isRemoteAddressEnabled(remoteIpAddress)) {
            return false;
        }
        if (isRestApi && !ipRestrictionConfig.restIpFilter().isRemoteAddressEnabled(remoteIpAddress)) {
            return false;
        }
        if (this.hostApp.shouldLoginManually(req, res)) {
            return false;
        }
        HttpSession session = req.getSession(false);
        if (session != null) {
            long secondsSinceLockout;
            Long lockoutTime = (Long)session.getAttribute(LOCKOUT_TIMESTAMP);
            long l = secondsSinceLockout = lockoutTime == null ? Long.MAX_VALUE : TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - lockoutTime);
            if (secondsSinceLockout < 1800L) {
                if (log.isDebugEnabled()) {
                    log.debug("Not initiating SPNEGO/WWW-Authenticate for request to '{}': Previous lockout {} seconds ago.", (Object)req.getRequestURI(), (Object)secondsSinceLockout);
                }
                this.failureListener.failed(LoginAttempt.attempt("Client session in temporary Kerberos lockout (user missing required group(s))", AtlasKerberosFilter.getRemoteIp(req)), req.getRequestURI());
                this.kerbConfManager.getStats().kerberosLockout();
                return false;
            }
        }
        return true;
    }

    private boolean isMappedRequest(HttpServletRequest req) {
        String r = HttpUrlUtils.getInternalPath(req);
        if (this.hostApp.isRequestMapped(req, r)) {
            log.debug("hostApp.isRequestMapped({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isRESTRequestMapped(req, r)) {
            log.debug("hostApp.isRestRequestMapped({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isPreemptiveRequestMapped(req) && this.kerbConfManager.isPreemptiveAuthEnabled() && !this.isPreemptivePathExcluded(req)) {
            log.debug("hostApp.isPreemptiveRequestMapped({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.isLoginRequest(req)) {
            log.debug("hostApp.isLoginRequest({}) => true", (Object)r);
            return true;
        }
        if (this.hostApp.shouldTryApiTokenAuthentication(req)) {
            log.debug("AtlasKerberosFilter.shouldTryApiAuthentication({}) => true", (Object)r);
            return true;
        }
        if (this.getUsernameFromHeader(req) != null) {
            log.debug("AtlasKerberosFilter.getUsernameFromHeader({}) => true", (Object)r);
            return true;
        }
        log.debug("AtlasKerberosFilter.isMappedRequest({}) => FALSE", (Object)r);
        return false;
    }

    private String getUsernameFromHeader(HttpServletRequest req) {
        boolean skipHeaderAuth;
        String remoteAddr = req.getRemoteAddr();
        if (this.kerbConfManager.isHeaderauthUseXForwardedFor()) {
            remoteAddr = AtlasKerberosFilter.getRemoteIpHeaderAuth(req);
        }
        String headerAttribute = this.kerbConfManager.getHeaderUsernameAttribute();
        String qs = req.getQueryString();
        boolean bl = skipHeaderAuth = StringUtils.contains((CharSequence)qs, "noheadersso") || StringUtils.contains((CharSequence)qs, "noautosso");
        if (IpRestrictionFilter.match(remoteAddr, this.kerbConfManager.getHeaderUsernameIpUnblockedlist()) && headerAttribute != null && !skipHeaderAuth) {
            return req.getHeader(headerAttribute);
        }
        return null;
    }

    private boolean isPreemptivePathExcluded(HttpServletRequest req) {
        if (this.isForwarded(req)) {
            return false;
        }
        String r = req.getRequestURI().substring(req.getContextPath().length()).toLowerCase();
        if (req.getQueryString() != null) {
            r = r + "?" + req.getQueryString();
        }
        for (String excludedPath : this.kerbConfManager.getPreemptiveAuthExcludedPaths()) {
            if (excludedPath != null && excludedPath.endsWith("*")) {
                excludedPath = excludedPath.substring(0, excludedPath.length() - 1);
            }
            if (!r.startsWith(excludedPath.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private boolean isForwarded(HttpServletRequest req) {
        return req.getAttribute("javax.servlet.forward.request_uri") != null;
    }

    private boolean isProductMatch() {
        for (String product : this.products) {
            if (!this.hostApp.isProductMatch(product)) continue;
            return true;
        }
        return false;
    }

    protected static String getRemoteIpHeaderAuth(HttpServletRequest req) {
        String forwardedFor = req.getHeader("[IP::client_addr]");
        if (forwardedFor != null) {
            return forwardedFor;
        }
        forwardedFor = req.getHeader("X-Forwarded-For");
        if (forwardedFor != null) {
            return forwardedFor;
        }
        return req.getRemoteAddr();
    }

    protected static String getRemoteIp(HttpServletRequest req) {
        String forwardedFor = req.getHeader("X-Forwarded-For");
        if (forwardedFor != null) {
            return forwardedFor;
        }
        return req.getRemoteAddr();
    }

    private IdpConfiguration getSamlHardRedirectProvider(HttpServletRequest req, HttpServletResponse resp) {
        if (this.hostApp.shouldDisableHardRedirect(req) || this.hostApp.shouldLoginManually(req, resp)) {
            return null;
        }
        List<IdpConfiguration> alls = this.idpConfManager.getProvidersByRedirectPolicy(IdpConfiguration.RedirectPolicy.HARD);
        if (this.loginScriptCondition.shouldDoFederatedSSO(req) && alls.size() == 1) {
            return alls.get(0);
        }
        return null;
    }

    private void dispatchToLogin(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws ServletException, IOException {
        log.debug("is response committed {}", (Object)resp.isCommitted());
        IdpConfiguration autoRedirect = this.getSamlHardRedirectProvider(req, resp);
        if (autoRedirect != null) {
            this.metaRefresh(req, resp, autoRedirect);
        } else {
            this.hostApp.dispatchToLogin(req, resp, chain);
        }
    }

    protected final void metaRefresh(HttpServletRequest req, HttpServletResponse resp, IdpConfiguration idpConfiguration) throws IOException {
        String target = this.hostApp.getRedirectTarget(req);
        resp.setContentType("text/html");
        StringBuilder cancelLink = new StringBuilder();
        cancelLink.append(req.getRequestURL().toString());
        cancelLink.append("?noautosso");
        String url = this.idpConfManager.getServiceProviderLoginURL(req, idpConfiguration.getId());
        if (target != null) {
            url = url + "?target=" + HttpUrlUtils.urlEncode(target);
        } else {
            String qs = req.getQueryString() != null ? "?" + req.getQueryString() : "";
            url = url + "?target=" + HttpUrlUtils.urlEncode(req.getRequestURI() + qs);
        }
        if (idpConfiguration.isHostedDomain() && idpConfiguration.getKnownDomains().iterator().hasNext()) {
            url = url + "&hd=" + (String)idpConfiguration.getKnownDomains().iterator().next();
        }
        resp.getWriter().print("<html><head><meta http-equiv=\"refresh\" content=\"1;URL='" + StringEscapeUtils.escapeHtml4(url) + "'\" /></head><p>Redirecting to sign-on.. <a style=\"font-size:small\" href=\"" + StringEscapeUtils.escapeHtml4(cancelLink.toString()) + "\">Cancel</a></p></html>");
    }

    public void destroy() {
    }

    private Principal authenticateWithProduct(HttpServletRequest req, HttpServletResponse res, Principal user) {
        if (this.kerbConfManager.isRemembermeCookieEnabled()) {
            this.hostApp.setRememberMeCookie(req, res, user.getName());
        }
        return this.hostApp.authenticateWithProduct(req, res, user);
    }

    private HttpServletRequest removeAuthHeader(HttpServletRequest request) {
        return new HttpServletRequestWrapper(request){
            private Set<String> headerNameSet;

            public Enumeration<String> getHeaderNames() {
                if (this.headerNameSet == null) {
                    this.headerNameSet = new HashSet<String>();
                    Enumeration wrappedHeaderNames = super.getHeaderNames();
                    while (wrappedHeaderNames.hasMoreElements()) {
                        String headerName = (String)wrappedHeaderNames.nextElement();
                        if ("Authorization".equalsIgnoreCase(headerName)) continue;
                        this.headerNameSet.add(headerName);
                    }
                }
                return Collections.enumeration(this.headerNameSet);
            }

            public Enumeration<String> getHeaders(String name) {
                if ("Authorization".equalsIgnoreCase(name)) {
                    return Collections.emptyEnumeration();
                }
                return super.getHeaders(name);
            }

            public String getHeader(String name) {
                if ("Authorization".equalsIgnoreCase(name)) {
                    return null;
                }
                return super.getHeader(name);
            }
        };
    }
}

