/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import shaded.org.apache.commons.codec.binary.Hex;

public class DigestUtils {
    static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static MessageDigest getMd5Digest() {
        return DigestUtils.getDigest("MD5");
    }

    private static MessageDigest getShaDigest() {
        return DigestUtils.getDigest("SHA");
    }

    public static byte[] md5(byte[] data) {
        return DigestUtils.getMd5Digest().digest(data);
    }

    public static byte[] md5(String data) {
        return DigestUtils.md5(data.getBytes());
    }

    public static String md5Hex(byte[] data) {
        return new String(Hex.encodeHex(DigestUtils.md5(data)));
    }

    public static String md5Hex(String data) {
        return new String(Hex.encodeHex(DigestUtils.md5(data)));
    }

    public static byte[] sha(byte[] data) {
        return DigestUtils.getShaDigest().digest(data);
    }

    public static byte[] sha(String data) {
        return DigestUtils.sha(data.getBytes());
    }

    public static String shaHex(byte[] data) {
        return new String(Hex.encodeHex(DigestUtils.sha(data)));
    }

    public static String shaHex(String data) {
        return new String(Hex.encodeHex(DigestUtils.sha(data)));
    }
}

