/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import kantega.shaded.com.google.common.collect.Lists;
import net.shibboleth.utilities.java.support.collection.LazyList;
import net.shibboleth.utilities.java.support.httpclient.HttpClientContextHandler;
import net.shibboleth.utilities.java.support.httpclient.HttpClientSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContextHandlingHttpClient
extends CloseableHttpClient {
    private Logger log = LoggerFactory.getLogger(ContextHandlingHttpClient.class);
    @Nonnull
    private CloseableHttpClient httpClient;
    @Nonnull
    private List<HttpClientContextHandler> handlers;

    public ContextHandlingHttpClient(@Nonnull CloseableHttpClient client) {
        this(client, null);
    }

    public ContextHandlingHttpClient(@Nonnull CloseableHttpClient client, @Nonnull List<HttpClientContextHandler> staticHandlers) {
        this.httpClient = Constraint.isNotNull(client, "HttpClient was null");
        this.handlers = staticHandlers != null ? staticHandlers : Collections.emptyList();
    }

    @Override
    public HttpParams getParams() {
        return this.httpClient.getParams();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return this.httpClient.getConnectionManager();
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Throwable error = null;
        HttpClientContext clientContext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
        HttpUriRequest uriRequest = HttpUriRequest.class.isInstance(request) ? (HttpUriRequest)request : HttpRequestWrapper.wrap(request, target);
        try {
            this.invokeBefore(uriRequest, clientContext);
            CloseableHttpResponse closeableHttpResponse = this.httpClient.execute(target, request, (HttpContext)clientContext);
            return closeableHttpResponse;
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            this.invokeAfter(uriRequest, clientContext, error);
        }
    }

    private void invokeBefore(HttpUriRequest request, HttpClientContext context) throws IOException {
        this.log.trace("In invokeBefore");
        LazyList<Throwable> errors = new LazyList<Throwable>();
        for (HttpClientContextHandler handler : this.handlers) {
            try {
                if (handler == null) continue;
                this.log.trace("Invoking static handler invokeBefore: {}", (Object)handler.getClass().getName());
                handler.invokeBefore(context, request);
            }
            catch (Throwable t) {
                this.log.warn("Static handler invokeBefore threw: {}", (Object)handler.getClass().getName(), (Object)t);
                errors.add(t);
            }
        }
        for (HttpClientContextHandler handler : HttpClientSupport.getDynamicContextHandlerList(context)) {
            try {
                if (handler == null) continue;
                this.log.trace("Invoking dynamic handler invokeBefore: {}", (Object)handler.getClass().getName());
                handler.invokeBefore(context, request);
            }
            catch (Throwable t) {
                this.log.warn("Dynamic handler invokeBefore threw: {}", (Object)handler.getClass().getName(), (Object)t);
                errors.add(t);
            }
        }
        IOException exception = this.processHandlerErrors("Invoke Before", errors);
        if (exception != null) {
            throw exception;
        }
    }

    private void invokeAfter(HttpUriRequest request, HttpClientContext context, Throwable priorError) throws IOException {
        this.log.trace("In invokeAfter");
        LazyList<Throwable> errors = new LazyList<Throwable>();
        for (HttpClientContextHandler handler : Lists.reverse(HttpClientSupport.getDynamicContextHandlerList(context))) {
            try {
                if (handler == null) continue;
                this.log.trace("Invoking dynamic handler invokeAfter: {}", (Object)handler.getClass().getName());
                handler.invokeAfter(context, request);
            }
            catch (Throwable t) {
                this.log.warn("Dynamic handler invokeAfter threw: {}", (Object)handler.getClass().getName(), (Object)t);
                errors.add(t);
            }
        }
        for (HttpClientContextHandler handler : Lists.reverse(this.handlers)) {
            try {
                if (handler == null) continue;
                this.log.trace("Invoking static handler invokeAfter: {}", (Object)handler.getClass().getName());
                handler.invokeAfter(context, request);
            }
            catch (Throwable t) {
                this.log.warn("Static handler invokeAfter threw: {}", (Object)handler.getClass().getName(), (Object)t);
                errors.add(t);
            }
        }
        IOException exception = this.processHandlerErrors("Invoke After", errors);
        this.processErrorsForInvokeAfter(exception, priorError);
    }

    private IOException processHandlerErrors(String stage, List<Throwable> errors) {
        if (errors == null || errors.isEmpty()) {
            return null;
        }
        if (errors.size() == 1) {
            Throwable t = errors.get(0);
            if (IOException.class.isInstance(t)) {
                return (IOException)IOException.class.cast(t);
            }
            return new IOException(String.format("Context handler threw non-IOException Throwable in stage '%s'", stage), t);
        }
        IOException e = new IOException(String.format("Multiple context handlers in stage '%s' reported error, see suppressed list", stage));
        for (Throwable t : errors) {
            e.addSuppressed(t);
        }
        return e;
    }

    private void processErrorsForInvokeAfter(IOException invokeAfterException, Throwable priorError) throws IOException {
        if (priorError != null) {
            if (invokeAfterException != null) {
                priorError.addSuppressed(invokeAfterException);
            }
            if (IOException.class.isInstance(priorError)) {
                throw (IOException)IOException.class.cast(priorError);
            }
            if (RuntimeException.class.isInstance(priorError)) {
                throw (RuntimeException)RuntimeException.class.cast(priorError);
            }
            if (Error.class.isInstance(priorError)) {
                throw (Error)Error.class.cast(priorError);
            }
            throw new RuntimeException(priorError);
        }
        if (invokeAfterException != null) {
            throw invokeAfterException;
        }
    }
}

