/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.spi;

import com.ksso.scim.ScimErrorType;
import com.ksso.scim.ScimResponseCode;
import io.vavr.control.Option;

public enum SpiError {
    USER_ALREADY_EXISTS(ScimResponseCode.CONFLICT, Option.of(ScimErrorType.UNIQUENESS)),
    GROUP_ALREADY_EXISTS(ScimResponseCode.CONFLICT, Option.of(ScimErrorType.UNIQUENESS)),
    USER_NOT_FOUND(ScimResponseCode.NOT_FOUND, Option.none()),
    GROUP_NOT_FOUND(ScimResponseCode.NOT_FOUND, Option.none()),
    USER_OR_GROUP_NOT_FOUND(ScimResponseCode.NOT_FOUND, Option.none()),
    MEMBERSHIP_UNKNOWN_GID(ScimResponseCode.BAD_REQUEST, Option.none()),
    MEMBERSHIP_UNKNOWN_UID(ScimResponseCode.BAD_REQUEST, Option.none()),
    VERSION_MISMATCH(ScimResponseCode.PRECONDITION_FAILED, Option.none()),
    TOO_MANY_RESULTS(ScimResponseCode.BAD_REQUEST, Option.of(ScimErrorType.TOO_MANY)),
    UNSUPPORTED_FILTER(ScimResponseCode.BAD_REQUEST, Option.of(ScimErrorType.INVALID_FILTER));

    private final ScimResponseCode code;
    private final Option<ScimErrorType> scimType;

    private SpiError(ScimResponseCode code, Option<ScimErrorType> scimType) {
        this.code = code;
        this.scimType = scimType;
    }

    public Option<ScimErrorType> getScimType() {
        return this.scimType;
    }

    public ScimResponseCode getCode() {
        return this.code;
    }
}

