/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.vo;

import com.ksso.scim.ScimResource;
import com.ksso.scim.schema.vo.ScimCommonAttr;
import com.ksso.scim.schema.vo.ScimGroupMember;
import com.ksso.scim.schema.vo.ScimName;
import com.ksso.scim.schema.vo.ScimObject;
import com.ksso.scim.schema.vo.ScimUserEnterpriseAttrs;
import com.ksso.scim.schema.vo.ScimUserGroup;
import io.vavr.collection.List;
import java.util.Objects;

public class ScimUser
extends ScimObject {
    private final String userName;
    private final String email;
    private final boolean active;
    private final List<ScimUserGroup> groups;
    private final ScimUserEnterpriseAttrs enterpriseAttr;
    private final ScimName name;

    public ScimUser(ScimCommonAttr commonAttr, ScimName name, String userName, String email, boolean active, ScimUserEnterpriseAttrs enterpriseAttrs, List<ScimUserGroup> groups2) {
        super(commonAttr);
        this.userName = Objects.requireNonNull(userName);
        this.groups = Objects.requireNonNull(groups2);
        this.email = email;
        this.name = name;
        this.active = active;
        this.enterpriseAttr = enterpriseAttrs;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getEmail() {
        return this.email;
    }

    public ScimName getName() {
        return this.name;
    }

    public List<ScimUserGroup> getGroups() {
        return this.groups;
    }

    public boolean isActive() {
        return this.active;
    }

    public ScimUserEnterpriseAttrs getEnterpriseAttr() {
        return this.enterpriseAttr;
    }

    public ScimGroupMember toScimGroupMember() {
        return new ScimGroupMember(this.commonAttr.getId(), this.userName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimUser scimUser = (ScimUser)o;
        return this.commonAttr.equals(scimUser.commonAttr) && this.userName.equals(scimUser.userName) && this.email.equals(scimUser.email) && this.name.equals(scimUser.name) && this.active == scimUser.active;
    }

    public int hashCode() {
        return Objects.hash(this.commonAttr, this.userName, this.email, this.name, this.active);
    }

    @Override
    public ScimResource getResourceType() {
        return ScimResource.USERS;
    }

    public String toString() {
        return "ScimUser{userName='" + this.userName + '\'' + ", email='" + this.email + '\'' + ", name='" + this.name + '\'' + ", active='" + this.active + '\'' + ", groups=" + this.groups + ", scimCommon=" + this.commonAttr + '}';
    }
}

