/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.vo;

import io.vavr.control.Option;
import java.util.Objects;

public class ScimName {
    private final String formatted;
    private final String familyName;
    private final String givenName;

    public ScimName(String formatted) {
        this(formatted, null, null);
    }

    public ScimName(String formatted, String familyName, String givenName) {
        this.formatted = Objects.requireNonNull(formatted);
        this.familyName = familyName;
        this.givenName = givenName;
    }

    public String getFormatted() {
        return this.formatted;
    }

    public Option<String> getFamilyName() {
        return Option.of(this.familyName);
    }

    public Option<String> getGivenName() {
        return Option.of(this.givenName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimName scimName = (ScimName)o;
        return this.formatted.equals(scimName.formatted) && Objects.equals(this.familyName, scimName.familyName) && Objects.equals(this.givenName, scimName.givenName);
    }

    public int hashCode() {
        return Objects.hash(this.formatted, this.familyName, this.givenName);
    }

    public String toString() {
        return "ScimName{formatted='" + this.formatted + '\'' + ", familyName='" + this.familyName + '\'' + ", givenName='" + this.givenName + '\'' + '}';
    }
}

